; psiplus-install.nsi
; http://psi-dev.googlecode.com/
; Psi+ installation script, v0.1.5
; Written by zet <mailto:vladimir.shelukhin@gmail.com>
; Date: 2010-07-18

; -----------------------------------------------------------------------------
; Define your application information
!define PRODUCT_NAME "Psi+"
!define PRODUCT_VERSION "0.15.2690 Beta"
!define COMPANY_NAME "Psi+ Dev Team"
!define PRODUCT_WEB_SITE "http://psi-dev.googlecode.com/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\psi.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; -----------------------------------------------------------------------------
; Main Install settings
Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
InstallDir "$PROGRAMFILES\Psi+"

;Get installation folder from registry if available
InstallDirRegKey HKLM "Software\${PRODUCT_NAME}" "InstallDir"

OutFile "setup\psi-plus-0.15.2690-win32-setup.exe"

; Use compression
SetCompressor /SOLID lzma

BrandingText "Copyright  2008-2010, ${COMPANY_NAME}"

; -----------------------------------------------------------------------------
; Version Information
VIAddVersionKey  "CompanyName"     "${COMPANY_NAME}"
VIAddVersionKey  "LegalCopyright"  " 2008-2010, ${COMPANY_NAME}"
VIAddVersionKey  "ProductName"     "${PRODUCT_NAME}"
VIAddVersionKey  "ProductVersion"  "${PRODUCT_VERSION}"
VIAddVersionKey  "FileDescription" "${PRODUCT_NAME} ${PRODUCT_VERSION}"
VIAddVersionKey  "FileVersion"     "${PRODUCT_VERSION}"
VIProductVersion "0.15.2690.0"

; -----------------------------------------------------------------------------
; The installer will perform a CRC on itself before allowing an install
CRCCheck on

; -----------------------------------------------------------------------------
; Request application privileges for Windows Vista
;RequestExecutionLevel admin

; -----------------------------------------------------------------------------
XPStyle on

; -----------------------------------------------------------------------------
; Modern interface settings
!include "MUI.nsh"

!define MUI_ABORTWARNING
!define MUI_ICON "setup\app.ico"
!define MUI_UNICON "setup\app.ico"
!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
;!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!insertmacro MUI_PAGE_LICENSE "setup\copying-psi.txt"

; Components page
!define MUI_COMPONENTSPAGE_NODESC
!insertmacro MUI_PAGE_COMPONENTS
;Page custom DisplayAdditionalTasksPage

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\psi.exe"
;!define MUI_FINISHPAGE_RUN_TEXT "&Run Psi+"
!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\changelog_cp1251.txt"
!define MUI_FINISHPAGE_SHOWREADME_TEXT "&Show Changelog"
!define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
!define MUI_FINISHPAGE_LINK "Psi+ Website"
!define MUI_FINISHPAGE_LINK_LOCATION "http://psi-dev.googlecode.com/"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
;!insertmacro MUI_UNPAGE_COMPONENTS
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH
!define MUI_UNFINISHPAGE_NOAUTOCLOSE

; -----------------------------------------------------------------------------
; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Russian"

; -----------------------------------------------------------------------------
; Reserve Files
  ; If you are using solid compression, files that are required before
  ; the actual installation should be stored first in the data block,
  ; because this will make your installer start faster.

;!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
!insertmacro MUI_RESERVEFILE_LANGDLL

; -----------------------------------------------------------------------------
ShowInstDetails show
ShowUninstDetails show

; -----------------------------------------------------------------------------
;Install Types
InstType Typical
InstType Full

; -----------------------------------------------------------------------------
;Function DisplayAdditionalTasksPage
;  !insertmacro MUI_HEADER_TEXT "Select Additional Tasks" "Which additional tasks should be done?"
;  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "AdditionalTasksPage.ini"
;FunctionEnd

; -----------------------------------------------------------------------------
;Installer Sections

Section "Psi+ Core Components" SectionPsiplusCoreComponents

	; Set Section properties
	SectionIn 1 2 RO
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "setup\app.ico"
	File "setup\changelog.txt"
	File "setup\changelog_cp1251.txt"
	File "setup\copying.txt"
	File "setup\copying-psi.txt"
	File "setup\iconv.dll"
	File "setup\idleui.dll"
	File "setup\libaspell-15.dll"
	File "setup\libeay32.dll"
	File "setup\libgcc_s_dw2-1.dll"
	File "setup\libintl-3.dll"
	File "setup\libssl32.dll"
	File "setup\mingwm10.dll"
	File "setup\psi.exe"
	File "setup\psi_ru.qm"
	File "setup\psi-portable.bat"
	File "setup\qca2.dll"
	File "setup\Qt3Support4.dll"
	File "setup\qt_ru.qm"
	File "setup\QtCore4.dll"
	File "setup\QtGui4.dll"
	File "setup\QtNetwork4.dll"
	File "setup\QtSql4.dll"
	File "setup\QtSvg4.dll"
	File "setup\QtXml4.dll"
	File "setup\version.txt"
	SetOutPath "$INSTDIR\aspell\data\"
	File "setup\aspell\data\dvorak.kbd"
	File "setup\aspell\data\koi8-r.cmap"
	File "setup\aspell\data\koi8-r.cset"
	File "setup\aspell\data\split.kbd"
	File "setup\aspell\data\standard.kbd"
	SetOutPath "$INSTDIR\aspell\dict\"
	File "setup\aspell\dict\en.dat"
	File "setup\aspell\dict\en.multi"
	File "setup\aspell\dict\en_US.multi"
	File "setup\aspell\dict\ru.dat"
	File "setup\aspell\dict\ru.multi"
	File "setup\aspell\dict\ruen.rws"
	File "setup\aspell\dict\ru_affix.dat"
	File "setup\aspell\dict\ru_RU.multi"
	SetOutPath "$INSTDIR\crypto\"
	File "setup\crypto\qca-gnupg2.dll"
	File "setup\crypto\qca-ossl2.dll"
	SetOutPath "$INSTDIR\iconsets\activities\"
	File "setup\iconsets\activities\psiplus-activities-16.jisp"
	File "setup\iconsets\activities\rederick-activities-16.jisp"
	File "setup\iconsets\activities\rederick-activities-20.jisp"
	File "setup\iconsets\activities\rederick-activities-22.jisp"
	File "setup\iconsets\activities\rederick-activities-24.jisp"
	File "setup\iconsets\activities\rederick-activities-32.jisp"
	File "setup\iconsets\activities\rederick-activities-48.jisp"
	File "setup\iconsets\activities\rederick-activities-64.jisp"
	SetOutPath "$INSTDIR\iconsets\affiliations\"
	File "setup\iconsets\affiliations\adium-affiliations.jisp"
	File "setup\iconsets\affiliations\balls-affiliations.jisp"
	File "setup\iconsets\affiliations\balls-medium-affiliations.jisp"
	File "setup\iconsets\affiliations\balls-small-affiliations.jisp"
	File "setup\iconsets\affiliations\black-affiliations.jisp"
	File "setup\iconsets\affiliations\bombus-nostalgic-affiliations.jisp"
	File "setup\iconsets\affiliations\medals-affiliations.jisp"
	File "setup\iconsets\affiliations\oxygen-affiliations-22.jisp"
	File "setup\iconsets\affiliations\oxygen-affiliations.jisp"
	File "setup\iconsets\affiliations\planets-affiliations.jisp"
	File "setup\iconsets\affiliations\qipinfium-affiliations.jisp"
	File "setup\iconsets\affiliations\smileys-affiliations.jisp"
	File "setup\iconsets\affiliations\tango-emotes-affiliations.jisp"
	File "setup\iconsets\affiliations\vista-halloween-affiliations.jisp"
	File "setup\iconsets\affiliations\white-affiliations.jisp"
	SetOutPath "$INSTDIR\iconsets\clients\"
	File "setup\iconsets\clients\fingerprint-22.jisp"
	File "setup\iconsets\clients\fingerprint.jisp"
	SetOutPath "$INSTDIR\iconsets\emoticons\"
	File "setup\iconsets\emoticons\Android.jisp"
	File "setup\iconsets\emoticons\bombus2psi.jisp"
	File "setup\iconsets\emoticons\GTalk-smiles.jisp"
	File "setup\iconsets\emoticons\kolobok.jisp"
	File "setup\iconsets\emoticons\kolobok_dark.jisp"
	File "setup\iconsets\emoticons\kolobok_light.jisp"
	File "setup\iconsets\emoticons\lgs_15x15.jisp"
	File "setup\iconsets\emoticons\lk_35x35x138_tasha.jisp"
	File "setup\iconsets\emoticons\mra-emoticons.jisp"
	File "setup\iconsets\emoticons\msn.jisp"
	File "setup\iconsets\emoticons\puzazBox.jisp"
	File "setup\iconsets\emoticons\qip_bigpack.jisp"
	File "setup\iconsets\emoticons\quip.jisp"
	File "setup\iconsets\emoticons\shinyicons.jisp"
	File "setup\iconsets\emoticons\tasha_18x18x93.jisp"
	File "setup\iconsets\emoticons\yaemomidget.jisp"
	File "setup\iconsets\emoticons\yahoo_gif.jisp"
	SetOutPath "$INSTDIR\iconsets\moods\"
	File "setup\iconsets\moods\Nova_UM.jisp"
	File "setup\iconsets\moods\rederick-moods-16.jisp"
	File "setup\iconsets\moods\rederick-moods-20.jisp"
	File "setup\iconsets\moods\rederick-moods-22.jisp"
	File "setup\iconsets\moods\rederick-moods-24.jisp"
	File "setup\iconsets\moods\rederick-moods-32.jisp"
	File "setup\iconsets\moods\rederick-moods-48.jisp"
	File "setup\iconsets\moods\rederick-moods-64.jisp"
	File "setup\iconsets\moods\silk.jisp"
	SetOutPath "$INSTDIR\iconsets\roster\"
	File "setup\iconsets\roster\amirosebulb.jisp"
	File "setup\iconsets\roster\amiroseglobe.jisp"
	File "setup\iconsets\roster\AmiroseStar.jisp"
	File "setup\iconsets\roster\Android.jisp"
	File "setup\iconsets\roster\archlinux.jisp"
	File "setup\iconsets\roster\bctango_roster.jisp"
	File "setup\iconsets\roster\berlin.jisp"
	File "setup\iconsets\roster\blackroster.jisp"
	File "setup\iconsets\roster\boss.jisp"
	File "setup\iconsets\roster\debian.jisp"
	File "setup\iconsets\roster\dictionary.jisp"
	File "setup\iconsets\roster\email.jisp"
	File "setup\iconsets\roster\gentoo.jisp"
	File "setup\iconsets\roster\graphite.jisp"
	File "setup\iconsets\roster\hearts.jisp"
	File "setup\iconsets\roster\hoodats.jisp"
	File "setup\iconsets\roster\icq.jisp"
	File "setup\iconsets\roster\individual.jisp"
	File "setup\iconsets\roster\Lamps.jisp"
	File "setup\iconsets\roster\linux.jisp"
	File "setup\iconsets\roster\maj-mail3.jisp"
	File "setup\iconsets\roster\mrim2006.jisp"
	File "setup\iconsets\roster\mrim2008.jisp"
	File "setup\iconsets\roster\muc.jisp"
	File "setup\iconsets\roster\nuvola-roster.jisp"
	File "setup\iconsets\roster\nuvola-smtp.jisp"
	File "setup\iconsets\roster\oxygen-roster-22.jisp"
	File "setup\iconsets\roster\oxygen.jisp"
	File "setup\iconsets\roster\qipinfium.jisp"
	File "setup\iconsets\roster\rss-classic.jisp"
	File "setup\iconsets\roster\rss.jisp"
	File "setup\iconsets\roster\slackware.jisp"
	File "setup\iconsets\roster\stafex_psi_mod.jisp"
	File "setup\iconsets\roster\stellar-crystalized-roster.jisp"
	File "setup\iconsets\roster\stellar-icq.jisp"
	File "setup\iconsets\roster\stellar.jisp"
	File "setup\iconsets\roster\suse.jisp"
	File "setup\iconsets\roster\tkabber.jisp"
	File "setup\iconsets\roster\transport.jisp"
	File "setup\iconsets\roster\VKontakte.ru.jisp"
	File "setup\iconsets\roster\weatheraqua.jisp"
	File "setup\iconsets\roster\white_theme.jisp"
	File "setup\iconsets\roster\yahoo.jisp"
	File "setup\iconsets\roster\YandexBigStatusIcons.jisp"
	File "setup\iconsets\roster\YandexStatusIcons.jisp"
	SetOutPath "$INSTDIR\iconsets\system\"
	File "setup\iconsets\system\blacksys.jisp"
	File "setup\iconsets\system\nuvola-system.jisp"
	File "setup\iconsets\system\oxygen_sys.jisp"
	File "setup\iconsets\system\oxygen_sys_22.jisp"
	File "setup\iconsets\system\qipinfium_sys.jisp"
	File "setup\iconsets\system\summer-system.jisp"
	File "setup\iconsets\system\tango_system.jisp"
	File "setup\iconsets\system\tkabber_sys.jisp"
	File "setup\iconsets\system\whitesys.jisp"
	SetOutPath "$INSTDIR\imageformats\"
	File "setup\imageformats\qgif4.dll"
	File "setup\imageformats\qico4.dll"
	File "setup\imageformats\qjpeg4.dll"
	File "setup\imageformats\qmng4.dll"
	File "setup\imageformats\qsvg4.dll"
	File "setup\imageformats\qtiff4.dll"
	SetOutPath "$INSTDIR\skins\"
	File "setup\skins\default_skin.png"
	File "setup\skins\default_skin.skn"
	SetOutPath "$INSTDIR\skins\mac\brushed_metal\"
	File "setup\skins\mac\brushed_metal\brush.png"
	File "setup\skins\mac\brushed_metal\brushed_metal.png"
	File "setup\skins\mac\brushed_metal\brushed_metal.skn"
	File "setup\skins\mac\brushed_metal\inf.png"
	SetOutPath "$INSTDIR\skins\universal\black_theme\"
	File "setup\skins\universal\black_theme\black_theme.png"
	File "setup\skins\universal\black_theme\black_theme.skn"
	SetOutPath "$INSTDIR\skins\universal\blue_skin\"
	File "setup\skins\universal\blue_skin\blue_skin.png"
	File "setup\skins\universal\blue_skin\blue_skin.skn"
	SetOutPath "$INSTDIR\skins\universal\night\"
	File "setup\skins\universal\night\bottom.png"
	File "setup\skins\universal\night\bottom_press.png"
	File "setup\skins\universal\night\gr.png"
	File "setup\skins\universal\night\gree.png"
	File "setup\skins\universal\night\green.png"
	File "setup\skins\universal\night\left.png"
	File "setup\skins\universal\night\left_press.png"
	File "setup\skins\universal\night\night.png"
	File "setup\skins\universal\night\night.skn"
	File "setup\skins\universal\night\right.png"
	File "setup\skins\universal\night\right_press.png"
	File "setup\skins\universal\night\top.png"
	File "setup\skins\universal\night\top_press.png"
	SetOutPath "$INSTDIR\skins\universal\orange\"
	File "setup\skins\universal\orange\chat.png"
	File "setup\skins\universal\orange\down.png"
	File "setup\skins\universal\orange\down_pres.png"
	File "setup\skins\universal\orange\left.png"
	File "setup\skins\universal\orange\left_pres.png"
	File "setup\skins\universal\orange\menu.png"
	File "setup\skins\universal\orange\orange.png"
	File "setup\skins\universal\orange\psi.png"
	File "setup\skins\universal\orange\right.png"
	File "setup\skins\universal\orange\right_pres.png"
	File "setup\skins\universal\orange\tbar.png"
	File "setup\skins\universal\orange\the_orange.png"
	File "setup\skins\universal\orange\the_orange.skn"
	File "setup\skins\universal\orange\tooltip.png"
	File "setup\skins\universal\orange\up.png"
	File "setup\skins\universal\orange\up_pres.png"
	SetOutPath "$INSTDIR\skins\universal\qip_infium\"
	File "setup\skins\universal\qip_infium\qip_infium.png"
	File "setup\skins\universal\qip_infium\qip_infium.skn"
	SetOutPath "$INSTDIR\skins\universal\sky\"
	File "setup\skins\universal\sky\sky.png"
	File "setup\skins\universal\sky\sky.skn"
	SetOutPath "$INSTDIR\skins\universal\tkabber\"
	File "setup\skins\universal\tkabber\tkabber.png"
	File "setup\skins\universal\tkabber\tkabber.skn"
	SetOutPath "$INSTDIR\sound\"
	File "setup\sound\attention.wav"
	File "setup\sound\chat1.wav"
	File "setup\sound\chat2.wav"
	File "setup\sound\chess_error.wav"
	File "setup\sound\chess_finish.wav"
	File "setup\sound\chess_move.wav"
	File "setup\sound\chess_start.wav"
	File "setup\sound\ft_complete.wav"
	File "setup\sound\ft_incoming.wav"
	File "setup\sound\offline.wav"
	File "setup\sound\online.wav"
	File "setup\sound\reminder.wav"
	File "setup\sound\send.wav"
	File "setup\sound\watcher.wav"
  WriteIniStr "$INSTDIR\Psi+ Website.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"

SectionEnd

Section "Psi+ Plugins" SectionPsiplusPlugins

	; Set Section properties
	SectionIn 1 2
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\plugins\"
	File "setup\plugins\aaastopspamplugin.dll"
	File "setup\plugins\attentionplugin.dll"
	File "setup\plugins\autoreplyplugin.dll"
	File "setup\plugins\birthdayreminderplugin.dll"
	File "setup\plugins\chessplugin.dll"
	File "setup\plugins\cleanerplugin.dll"
	File "setup\plugins\conferenceloggerplugin.dll"
	File "setup\plugins\extendedoptionsplugin.dll"
	File "setup\plugins\gmailnotifyplugin.dll"
	File "setup\plugins\historykeeperplugin.dll"
	File "setup\plugins\icqdieplugin.dll"
	File "setup\plugins\imageplugin.dll"
	File "setup\plugins\juickplugin.dll"
	File "setup\plugins\qipxstatusesplugin.dll"
	File "setup\plugins\screenshotplugin.dll"
	File "setup\plugins\skinsplugin.dll"
	File "setup\plugins\storagenotesplugin.dll"
	File "setup\plugins\translateplugin.dll"
	File "setup\plugins\watcherplugin.dll"

SectionEnd


Section "Psimedia+" SectionPsimediaplus

	; Set Section properties
	SectionIn 1 2
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "setup\gstprovider.dll"
	File "setup\libgio-2.0-0.dll"
	File "setup\libglib-2.0-0.dll"
	File "setup\libgmodule-2.0-0.dll"
	File "setup\libgobject-2.0-0.dll"
	File "setup\libgstaudio-0.10-0.dll"
	File "setup\libgstbase-0.10-0.dll"
	File "setup\libgstcontroller-0.10-0.dll"
	File "setup\libgstinterfaces-0.10-0.dll"
	File "setup\libgstnetbuffer-0.10-0.dll"
	File "setup\libgstpbutils-0.10-0.dll"
	File "setup\libgstreamer-0.10-0.dll"
	File "setup\libgstriff-0.10-0.dll"
	File "setup\libgstrtp-0.10-0.dll"
	File "setup\libgsttag-0.10-0.dll"
	File "setup\libgstvideo-0.10-0.dll"
	File "setup\libgthread-2.0-0.dll"
	File "setup\libiconv-2.dll"
	File "setup\libintl-8.dll"
	File "setup\libjpeg-8.dll"
	File "setup\libltdl-7.dll"
	File "setup\libogg-0.dll"
	File "setup\liboil-0.3-0.dll"
	File "setup\libspeex-1.dll"
	File "setup\libspeexdsp-1.dll"
	File "setup\libtheora-0.dll"
	File "setup\libtheoradec-1.dll"
	File "setup\libtheoraenc-1.dll"
	File "setup\libvorbis-0.dll"
	File "setup\libvorbisenc-2.dll"
	File "setup\libvorbisfile-3.dll"
	File "setup\libxml2-2.dll"
	File "setup\libz-1.dll"
	File "setup\psimedia-readme.txt"
	SetOutPath "$INSTDIR\gstreamer-0.10\"
	File "setup\gstreamer-0.10\libgstaudioconvert.dll"
	File "setup\gstreamer-0.10\libgstaudioresample.dll"
	File "setup\gstreamer-0.10\libgstcoreelements.dll"
	File "setup\gstreamer-0.10\libgstcoreindexers.dll"
	File "setup\gstreamer-0.10\libgstdecodebin.dll"
	File "setup\gstreamer-0.10\libgstffmpegcolorspace.dll"
	File "setup\gstreamer-0.10\libgstjpeg.dll"
	File "setup\gstreamer-0.10\libgstlevel.dll"
	File "setup\gstreamer-0.10\libgstogg.dll"
	File "setup\gstreamer-0.10\libgstrtp.dll"
	File "setup\gstreamer-0.10\libgstspeex.dll"
	File "setup\gstreamer-0.10\libgsttheora.dll"
	File "setup\gstreamer-0.10\libgsttypefindfunctions.dll"
	File "setup\gstreamer-0.10\libgstvideorate.dll"
	File "setup\gstreamer-0.10\libgstvideoscale.dll"
	File "setup\gstreamer-0.10\libgstvolume.dll"
	File "setup\gstreamer-0.10\libgstvorbis.dll"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PSI_ENABLE_VIDEO" "1"

SectionEnd

; Optional Start menu shortcut section
Section "Start Menu Shortcuts" SectionStartMenuShortcuts
	
	SectionIn 1 2
	CreateDirectory "$SMPROGRAMS\Psi+"
	CreateShortCut "$SMPROGRAMS\Psi+\Psi+.lnk" "$INSTDIR\psi.exe"
	CreateShortCut "$SMPROGRAMS\Psi+\Psi+ Portable.lnk" "$INSTDIR\psi-portable.bat"
	CreateShortCut "$SMPROGRAMS\Psi+\Psi+ Changelog.lnk" "$INSTDIR\changelog_cp1251.txt"
  CreateShortCut "$SMPROGRAMS\Psi+\Uninstall.lnk" "$INSTDIR\uninstall.exe"
  CreateShortCut "$SMPROGRAMS\Psi+\Website.lnk" "$INSTDIR\${PRODUCT_NAME} Website.url"
	
SectionEnd

; Optional Desktop shortcut section
Section "Desktop Shortcut" SectionDesktopShortcut
	
	SectionIn 2
	CreateShortCut "$DESKTOP\Psi+.lnk" "$INSTDIR\psi.exe"
	
SectionEnd

; Optional Quick Launch shortcut section
Section "Quick Launch Shortcut" SectionQuickLaunchShortcut
  
	SectionIn 2
  CreateShortCut  "$QUICKLAUNCH\Psi+.lnk" "$INSTDIR\psi.exe"

SectionEnd

Section -FinishSection

  WriteUninstaller "$INSTDIR\uninstall.exe"
	WriteRegExpandStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteRegExpandStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallLocation" "$INSTDIR"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "Software\${PRODUCT_NAME}" "" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\psi.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "${PRODUCT_NAME}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\psi.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "HelpLink" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${COMPANY_NAME}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoModify" "1"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoRepair" "1"

SectionEnd

; -----------------------------------------------------------------------------
;Component Section Descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionPsiplusCoreComponents} "Psi+ core files (required)"
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionPsiplusPlugins} "Psi+ Plugins"
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionPsimediaplus} "Psimedia+ libraries"
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionStartMenuShortcuts} "Psi+ Start Menu shortcuts"
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionDesktopShortcut} "Psi+ Desktop shortcut"
	!insertmacro MUI_DESCRIPTION_TEXT ${SectionQuickLaunchShortcut} "Psi+ Quick Launch shortcut"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

; -----------------------------------------------------------------------------
;Uninstall section
Section Uninstall

	;Remove from registry...
	DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "SOFTWARE\${PRODUCT_NAME}"
	DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}"
	DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\Psi+.lnk"
  Delete "$QUICKLAUNCH\Psi+.lnk"

  ; Clean up Psi+ Core Components
	Delete "$INSTDIR\Psi+ Website.url"
	Delete "$INSTDIR\app.ico"
	Delete "$INSTDIR\changelog.txt"
	Delete "$INSTDIR\changelog_cp1251.txt"
	Delete "$INSTDIR\copying.txt"
	Delete "$INSTDIR\copying-psi.txt"
	Delete "$INSTDIR\iconv.dll"
	Delete "$INSTDIR\idleui.dll"
	Delete "$INSTDIR\libaspell-15.dll"
	Delete "$INSTDIR\libeay32.dll"
	Delete "$INSTDIR\libgcc_s_dw2-1.dll"
	Delete "$INSTDIR\libintl-3.dll"
	Delete "$INSTDIR\libssl32.dll"
	Delete "$INSTDIR\mingwm10.dll"
	Delete "$INSTDIR\psi.exe"
	Delete "$INSTDIR\psi_ru.qm"
	Delete "$INSTDIR\psi-portable.bat"
	Delete "$INSTDIR\qca2.dll"
	Delete "$INSTDIR\Qt3Support4.dll"
	Delete "$INSTDIR\qt_ru.qm"
	Delete "$INSTDIR\QtCore4.dll"
	Delete "$INSTDIR\QtGui4.dll"
	Delete "$INSTDIR\QtNetwork4.dll"
	Delete "$INSTDIR\QtSql4.dll"
	Delete "$INSTDIR\QtSvg4.dll"
	Delete "$INSTDIR\QtXml4.dll"
	Delete "$INSTDIR\version.txt"
	Delete "$INSTDIR\aspell\data\dvorak.kbd"
	Delete "$INSTDIR\aspell\data\koi8-r.cmap"
	Delete "$INSTDIR\aspell\data\koi8-r.cset"
	Delete "$INSTDIR\aspell\data\split.kbd"
	Delete "$INSTDIR\aspell\data\standard.kbd"
	Delete "$INSTDIR\aspell\dict\en.dat"
	Delete "$INSTDIR\aspell\dict\en.multi"
	Delete "$INSTDIR\aspell\dict\en_US.multi"
	Delete "$INSTDIR\aspell\dict\ru.dat"
	Delete "$INSTDIR\aspell\dict\ru.multi"
	Delete "$INSTDIR\aspell\dict\ruen.rws"
	Delete "$INSTDIR\aspell\dict\ru_affix.dat"
	Delete "$INSTDIR\aspell\dict\ru_RU.multi"
	Delete "$INSTDIR\crypto\qca-gnupg2.dll"
	Delete "$INSTDIR\crypto\qca-ossl2.dll"
	Delete "$INSTDIR\iconsets\activities\psiplus-activities-16.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-16.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-20.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-22.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-24.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-32.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-48.jisp"
	Delete "$INSTDIR\iconsets\activities\rederick-activities-64.jisp"
	Delete "$INSTDIR\iconsets\affiliations\adium-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\balls-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\balls-medium-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\balls-small-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\black-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\bombus-nostalgic-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\medals-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\oxygen-affiliations-22.jisp"
	Delete "$INSTDIR\iconsets\affiliations\oxygen-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\planets-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\qipinfium-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\smileys-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\tango-emotes-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\vista-halloween-affiliations.jisp"
	Delete "$INSTDIR\iconsets\affiliations\white-affiliations.jisp"
	Delete "$INSTDIR\iconsets\clients\fingerprint-22.jisp"
	Delete "$INSTDIR\iconsets\clients\fingerprint.jisp"
	Delete "$INSTDIR\iconsets\emoticons\Android.jisp"
	Delete "$INSTDIR\iconsets\emoticons\bombus2psi.jisp"
	Delete "$INSTDIR\iconsets\emoticons\GTalk-smiles.jisp"
	Delete "$INSTDIR\iconsets\emoticons\kolobok.jisp"
	Delete "$INSTDIR\iconsets\emoticons\kolobok_dark.jisp"
	Delete "$INSTDIR\iconsets\emoticons\kolobok_light.jisp"
	Delete "$INSTDIR\iconsets\emoticons\lgs_15x15.jisp"
	Delete "$INSTDIR\iconsets\emoticons\lk_35x35x138_tasha.jisp"
	Delete "$INSTDIR\iconsets\emoticons\mra-emoticons.jisp"
	Delete "$INSTDIR\iconsets\emoticons\msn.jisp"
	Delete "$INSTDIR\iconsets\emoticons\puzazBox.jisp"
	Delete "$INSTDIR\iconsets\emoticons\qip_bigpack.jisp"
	Delete "$INSTDIR\iconsets\emoticons\quip.jisp"
	Delete "$INSTDIR\iconsets\emoticons\shinyicons.jisp"
	Delete "$INSTDIR\iconsets\emoticons\tasha_18x18x93.jisp"
	Delete "$INSTDIR\iconsets\emoticons\yaemomidget.jisp"
	Delete "$INSTDIR\iconsets\emoticons\yahoo_gif.jisp"
	Delete "$INSTDIR\iconsets\moods\Nova_UM.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-16.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-20.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-22.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-24.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-32.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-48.jisp"
	Delete "$INSTDIR\iconsets\moods\rederick-moods-64.jisp"
	Delete "$INSTDIR\iconsets\moods\silk.jisp"
	Delete "$INSTDIR\iconsets\roster\amirosebulb.jisp"
	Delete "$INSTDIR\iconsets\roster\amiroseglobe.jisp"
	Delete "$INSTDIR\iconsets\roster\AmiroseStar.jisp"
	Delete "$INSTDIR\iconsets\roster\Android.jisp"
	Delete "$INSTDIR\iconsets\roster\archlinux.jisp"
	Delete "$INSTDIR\iconsets\roster\bctango_roster.jisp"
	Delete "$INSTDIR\iconsets\roster\berlin.jisp"
	Delete "$INSTDIR\iconsets\roster\blackroster.jisp"
	Delete "$INSTDIR\iconsets\roster\boss.jisp"
	Delete "$INSTDIR\iconsets\roster\debian.jisp"
	Delete "$INSTDIR\iconsets\roster\dictionary.jisp"
	Delete "$INSTDIR\iconsets\roster\email.jisp"
	Delete "$INSTDIR\iconsets\roster\gentoo.jisp"
	Delete "$INSTDIR\iconsets\roster\graphite.jisp"
	Delete "$INSTDIR\iconsets\roster\hearts.jisp"
	Delete "$INSTDIR\iconsets\roster\hoodats.jisp"
	Delete "$INSTDIR\iconsets\roster\icq.jisp"
	Delete "$INSTDIR\iconsets\roster\individual.jisp"
	Delete "$INSTDIR\iconsets\roster\Lamps.jisp"
	Delete "$INSTDIR\iconsets\roster\linux.jisp"
	Delete "$INSTDIR\iconsets\roster\maj-mail3.jisp"
	Delete "$INSTDIR\iconsets\roster\mrim2006.jisp"
	Delete "$INSTDIR\iconsets\roster\mrim2008.jisp"
	Delete "$INSTDIR\iconsets\roster\muc.jisp"
	Delete "$INSTDIR\iconsets\roster\nuvola-roster.jisp"
	Delete "$INSTDIR\iconsets\roster\nuvola-smtp.jisp"
	Delete "$INSTDIR\iconsets\roster\oxygen-roster-22.jisp"
	Delete "$INSTDIR\iconsets\roster\oxygen.jisp"
	Delete "$INSTDIR\iconsets\roster\qipinfium.jisp"
	Delete "$INSTDIR\iconsets\roster\rss-classic.jisp"
	Delete "$INSTDIR\iconsets\roster\rss.jisp"
	Delete "$INSTDIR\iconsets\roster\slackware.jisp"
	Delete "$INSTDIR\iconsets\roster\stafex_psi_mod.jisp"
	Delete "$INSTDIR\iconsets\roster\stellar-crystalized-roster.jisp"
	Delete "$INSTDIR\iconsets\roster\stellar-icq.jisp"
	Delete "$INSTDIR\iconsets\roster\stellar.jisp"
	Delete "$INSTDIR\iconsets\roster\suse.jisp"
	Delete "$INSTDIR\iconsets\roster\tkabber.jisp"
	Delete "$INSTDIR\iconsets\roster\transport.jisp"
	Delete "$INSTDIR\iconsets\roster\VKontakte.ru.jisp"
	Delete "$INSTDIR\iconsets\roster\weatheraqua.jisp"
	Delete "$INSTDIR\iconsets\roster\white_theme.jisp"
	Delete "$INSTDIR\iconsets\roster\yahoo.jisp"
	Delete "$INSTDIR\iconsets\roster\YandexBigStatusIcons.jisp"
	Delete "$INSTDIR\iconsets\roster\YandexStatusIcons.jisp"
	Delete "$INSTDIR\iconsets\system\blacksys.jisp"
	Delete "$INSTDIR\iconsets\system\nuvola-system.jisp"
	Delete "$INSTDIR\iconsets\system\oxygen_sys.jisp"
	Delete "$INSTDIR\iconsets\system\oxygen_sys_22.jisp"
	Delete "$INSTDIR\iconsets\system\qipinfium_sys.jisp"
	Delete "$INSTDIR\iconsets\system\summer-system.jisp"
	Delete "$INSTDIR\iconsets\system\tango_system.jisp"
	Delete "$INSTDIR\iconsets\system\tkabber_sys.jisp"
	Delete "$INSTDIR\iconsets\system\whitesys.jisp"
	Delete "$INSTDIR\imageformats\qgif4.dll"
	Delete "$INSTDIR\imageformats\qico4.dll"
	Delete "$INSTDIR\imageformats\qjpeg4.dll"
	Delete "$INSTDIR\imageformats\qmng4.dll"
	Delete "$INSTDIR\imageformats\qsvg4.dll"
	Delete "$INSTDIR\imageformats\qtiff4.dll"
	Delete "$INSTDIR\skins\default_skin.png"
	Delete "$INSTDIR\skins\default_skin.skn"
	Delete "$INSTDIR\skins\mac\brushed_metal\brush.png"
	Delete "$INSTDIR\skins\mac\brushed_metal\brushed_metal.png"
	Delete "$INSTDIR\skins\mac\brushed_metal\brushed_metal.skn"
	Delete "$INSTDIR\skins\mac\brushed_metal\inf.png"
	Delete "$INSTDIR\skins\universal\black_theme\black_theme.png"
	Delete "$INSTDIR\skins\universal\black_theme\black_theme.skn"
	Delete "$INSTDIR\skins\universal\blue_skin\blue_skin.png"
	Delete "$INSTDIR\skins\universal\blue_skin\blue_skin.skn"
	Delete "$INSTDIR\skins\universal\night\bottom.png"
	Delete "$INSTDIR\skins\universal\night\bottom_press.png"
	Delete "$INSTDIR\skins\universal\night\gr.png"
	Delete "$INSTDIR\skins\universal\night\gree.png"
	Delete "$INSTDIR\skins\universal\night\green.png"
	Delete "$INSTDIR\skins\universal\night\left.png"
	Delete "$INSTDIR\skins\universal\night\left_press.png"
	Delete "$INSTDIR\skins\universal\night\night.png"
	Delete "$INSTDIR\skins\universal\night\night.skn"
	Delete "$INSTDIR\skins\universal\night\right.png"
	Delete "$INSTDIR\skins\universal\night\right_press.png"
	Delete "$INSTDIR\skins\universal\night\top.png"
	Delete "$INSTDIR\skins\universal\night\top_press.png"
	Delete "$INSTDIR\skins\universal\orange\chat.png"
	Delete "$INSTDIR\skins\universal\orange\down.png"
	Delete "$INSTDIR\skins\universal\orange\down_pres.png"
	Delete "$INSTDIR\skins\universal\orange\left.png"
	Delete "$INSTDIR\skins\universal\orange\left_pres.png"
	Delete "$INSTDIR\skins\universal\orange\menu.png"
	Delete "$INSTDIR\skins\universal\orange\orange.png"
	Delete "$INSTDIR\skins\universal\orange\psi.png"
	Delete "$INSTDIR\skins\universal\orange\right.png"
	Delete "$INSTDIR\skins\universal\orange\right_pres.png"
	Delete "$INSTDIR\skins\universal\orange\tbar.png"
	Delete "$INSTDIR\skins\universal\orange\the_orange.png"
	Delete "$INSTDIR\skins\universal\orange\the_orange.skn"
	Delete "$INSTDIR\skins\universal\orange\tooltip.png"
	Delete "$INSTDIR\skins\universal\orange\up.png"
	Delete "$INSTDIR\skins\universal\orange\up_pres.png"
	Delete "$INSTDIR\skins\universal\qip_infium\qip_infium.png"
	Delete "$INSTDIR\skins\universal\qip_infium\qip_infium.skn"
	Delete "$INSTDIR\skins\universal\sky\sky.png"
	Delete "$INSTDIR\skins\universal\sky\sky.skn"
	Delete "$INSTDIR\skins\universal\tkabber\tkabber.png"
	Delete "$INSTDIR\skins\universal\tkabber\tkabber.skn"
	Delete "$INSTDIR\sound\attention.wav"
	Delete "$INSTDIR\sound\chat1.wav"
	Delete "$INSTDIR\sound\chat2.wav"
	Delete "$INSTDIR\sound\chess_error.wav"
	Delete "$INSTDIR\sound\chess_finish.wav"
	Delete "$INSTDIR\sound\chess_move.wav"
	Delete "$INSTDIR\sound\chess_start.wav"
	Delete "$INSTDIR\sound\ft_complete.wav"
	Delete "$INSTDIR\sound\ft_incoming.wav"
	Delete "$INSTDIR\sound\offline.wav"
	Delete "$INSTDIR\sound\online.wav"
	Delete "$INSTDIR\sound\reminder.wav"
	Delete "$INSTDIR\sound\send.wav"
	Delete "$INSTDIR\sound\watcher.wav"

	; Clean up Psi+ Plugins
	Delete "$INSTDIR\plugins\aaastopspamplugin.dll"
	Delete "$INSTDIR\plugins\attentionplugin.dll"
	Delete "$INSTDIR\plugins\autoreplyplugin.dll"
	Delete "$INSTDIR\plugins\birthdayreminderplugin.dll"
	Delete "$INSTDIR\plugins\chessplugin.dll"
	Delete "$INSTDIR\plugins\cleanerplugin.dll"
	Delete "$INSTDIR\plugins\conferenceloggerplugin.dll"
	Delete "$INSTDIR\plugins\extendedoptionsplugin.dll"
	Delete "$INSTDIR\plugins\gmailnotifyplugin.dll"
	Delete "$INSTDIR\plugins\historykeeperplugin.dll"
	Delete "$INSTDIR\plugins\icqdieplugin.dll"
	Delete "$INSTDIR\plugins\imageplugin.dll"
	Delete "$INSTDIR\plugins\juickplugin.dll"
	Delete "$INSTDIR\plugins\qipxstatusesplugin.dll"
	Delete "$INSTDIR\plugins\screenshotplugin.dll"
	Delete "$INSTDIR\plugins\skinsplugin.dll"
	Delete "$INSTDIR\plugins\storagenotesplugin.dll"
	Delete "$INSTDIR\plugins\translateplugin.dll"
	Delete "$INSTDIR\plugins\watcherplugin.dll"

  ; Clean up Psimedia+
  DeleteRegValue ${PRODUCT_UNINST_ROOT_KEY} "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PSI_ENABLE_VIDEO"
  Delete "$INSTDIR\gstprovider.dll"
	Delete "$INSTDIR\libgio-2.0-0.dll"
	Delete "$INSTDIR\libglib-2.0-0.dll"
	Delete "$INSTDIR\libgmodule-2.0-0.dll"
	Delete "$INSTDIR\libgobject-2.0-0.dll"
	Delete "$INSTDIR\libgstaudio-0.10-0.dll"
	Delete "$INSTDIR\libgstbase-0.10-0.dll"
	Delete "$INSTDIR\libgstcontroller-0.10-0.dll"
	Delete "$INSTDIR\libgstinterfaces-0.10-0.dll"
	Delete "$INSTDIR\libgstnetbuffer-0.10-0.dll"
	Delete "$INSTDIR\libgstpbutils-0.10-0.dll"
	Delete "$INSTDIR\libgstreamer-0.10-0.dll"
	Delete "$INSTDIR\libgstriff-0.10-0.dll"
	Delete "$INSTDIR\libgstrtp-0.10-0.dll"
	Delete "$INSTDIR\libgsttag-0.10-0.dll"
	Delete "$INSTDIR\libgstvideo-0.10-0.dll"
	Delete "$INSTDIR\libgthread-2.0-0.dll"
	Delete "$INSTDIR\libiconv-2.dll"
	Delete "$INSTDIR\libintl-3.dll"
	Delete "$INSTDIR\libintl-8.dll"
	Delete "$INSTDIR\libjpeg-8.dll"
	Delete "$INSTDIR\libltdl-7.dll"
	Delete "$INSTDIR\libogg-0.dll"
	Delete "$INSTDIR\liboil-0.3-0.dll"
	Delete "$INSTDIR\libspeex-1.dll"
	Delete "$INSTDIR\libspeexdsp-1.dll"
	Delete "$INSTDIR\libtheora-0.dll"
	Delete "$INSTDIR\libtheoradec-1.dll"
	Delete "$INSTDIR\libtheoraenc-1.dll"
	Delete "$INSTDIR\libvorbis-0.dll"
	Delete "$INSTDIR\libvorbisenc-2.dll"
	Delete "$INSTDIR\libvorbisfile-3.dll"
	Delete "$INSTDIR\libxml2-2.dll"
	Delete "$INSTDIR\libz-1.dll"
	Delete "$INSTDIR\psimedia-readme.txt"
	Delete "$INSTDIR\gstreamer-0.10\libgstaudioconvert.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstaudioresample.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstcoreelements.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstcoreindexers.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstdecodebin.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstffmpegcolorspace.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstjpeg.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstlevel.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstogg.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstrtp.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstspeex.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgsttheora.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgsttypefindfunctions.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstvideorate.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstvideoscale.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstvolume.dll"
	Delete "$INSTDIR\gstreamer-0.10\libgstvorbis.dll"

  ; Remove remaining directories
  RMDir /r "$SMPROGRAMS\Psi+"
	RMDir "$INSTDIR\sound\"
	RMDir "$INSTDIR\skins\universal\tkabber\"
	RMDir "$INSTDIR\skins\universal\sky\"
	RMDir "$INSTDIR\skins\universal\qip_infium\"
	RMDir "$INSTDIR\skins\universal\orange\"
	RMDir "$INSTDIR\skins\universal\night\"
	RMDir "$INSTDIR\skins\universal\blue_skin\"
	RMDir "$INSTDIR\skins\universal\black_theme\"
	RMDir "$INSTDIR\skins\universal\"
	RMDir "$INSTDIR\skins\mac\brushed_metal\"
	RMDir "$INSTDIR\skins\mac\"
	RMDir "$INSTDIR\skins\"
	RMDir "$INSTDIR\plugins\"
	RMDir "$INSTDIR\imageformats\"
	RMDir "$INSTDIR\iconsets\system\"
	RMDir "$INSTDIR\iconsets\roster\"
	RMDir "$INSTDIR\iconsets\moods\"
	RMDir "$INSTDIR\iconsets\emoticons\"
	RMDir "$INSTDIR\iconsets\clients\"
	RMDir "$INSTDIR\iconsets\affiliations\"
	RMDir "$INSTDIR\iconsets\activities\"
	RMDir "$INSTDIR\iconsets\"
	RMDir "$INSTDIR\gstreamer-0.10\"
	RMDir "$INSTDIR\crypto\"
	RMDir "$INSTDIR\aspell\dict\"
	RMDir "$INSTDIR\aspell\data\"
	RMDir "$INSTDIR\aspell\"
	RMDir "$INSTDIR\"

SectionEnd

; -----------------------------------------------------------------------------
; On initialization
Function .onInit

	!insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd
