#ifndef OPTIONSPARSER_H
#define OPTIONSPARSER_H

#include <QDomElement>
#include <QMap>
#include <QStringList>

class OptionsParser : public QObject
{
    Q_OBJECT

public:
    OptionsParser(QString fileName, QObject *parent = 0);
    QStringList getMissingNodesString();
    QList<QDomNode> getMissingNodes();
    QDomNode nodeByString(QString key);


private:
    QString fileName_;
    QDomElement optionsElement_, defaultsElement_;
    QMap<QString, QDomNode> missingNodes;

    void findMissingOptions(QDomElement optElement, QString &root);
    bool findNode(QDomElement elem);

};

#endif // OPTIONSPARSER_H
