#ifndef SCREENSHOT_H
#define SCREENSHOT_H

#include <QPointer>
#include <QNetworkReply>

#include "ui_screenshot.h"
#include "server.h"
#include "iconfactoryaccessinghost.h"
#include "toolbar.h"

class Screenshot : public QMainWindow
{
    Q_OBJECT

public:
	Screenshot(IconFactoryAccessingHost* icoHost_, QString aFileNameFormat = "pic-yyyyMMdd-hhmmss", QString aFormat = "png");
	~Screenshot();

	void setFormat(QString aFormat);
	void setFileNameFormat(QString aFileNameFormat);
	void setServersList(QStringList servers);
	void setImagePath(QString path);

protected:
	bool eventFilter(QObject *obj, QEvent *e);

public slots:
	void shootScreen();
	void openImage();

private slots:
	void saveScreenshot();
	void uploadScreenshot();
	void cancelUpload();
	void dataTransferProgress( qint64 done, qint64 total );
	void ftpReplyFinished();
	void httpReplyFinished(QNetworkReply*);
	void replyError(QNetworkReply::NetworkError);
	void newScreenshot();
	void captureDesktop(int);
	//void captureWindow(int);
	void captureArea(int);	
	//void shootWindow();
	void shootArea();
	void screenshotCanceled();
	void pixmapAdjusted();
	void fixSizes();

private:
	void updateScreenshotLabel();
	void uploadFtp();
	void uploadHttp();
	void showError(QString error);
	void bringToFront();

	QPixmap originalPixmap;
	Ui::Screenshot ui_;
	QString format;
	QString fileNameFormat;
	QList<Server*> servers;
	QPointer<QNetworkAccessManager> manager;
	QUrl u;
	QByteArray ba;

	int x, y, newX, newY, delay_;

	IconFactoryAccessingHost* icoHost;
};


#endif
