#include "screenshotoptions.h"
#include <QTimer>

ScreenshotOptions::ScreenshotOptions(int delay, QWidget *parent)
	: QDialog(parent)
{
	setAttribute(Qt::WA_DeleteOnClose);
	ui_.setupUi(this);
	ui_.rb_capture_window->setVisible(false); ///FIXME!!!!!!
#ifndef Q_WS_X11
	ui_.rb_capture_area->setVisible(false);
#endif
	ui_.sb_delay->setValue(delay);

	connect(ui_.buttonBox, SIGNAL(accepted()), SLOT(okPressed()));
	connect(ui_.buttonBox,SIGNAL(rejected()), SLOT(cancelPressed()));

	adjustSize();
	setFixedSize(size());
}

void ScreenshotOptions::okPressed()
{
	hide();
	QTimer::singleShot(100, this, SLOT(hideTimeout())); // чтобы при задержке 0сек это окно успело скрыться
}

void ScreenshotOptions::hideTimeout()
{
	int delay = ui_.sb_delay->value();
	if(ui_.rb_capture_desktop->isChecked())
		emit captureDesktop(delay);
	else if(ui_.rb_capture_window->isChecked())
		emit captureWindow(delay);
	else if(ui_.rb_capture_area->isChecked())
		emit captureArea(delay);
	close();
}

void ScreenshotOptions::cancelPressed()
{
	emit screenshotCanceled();
	close();
}
