#ifndef NOTES_H
#define NOTES_H

#include "ui_notes.h"
#include "storagenotesplugin.h"
#include "tagsmodel.h"

#include <QKeyEvent>

class Notes : public QDialog
{
        Q_OBJECT
public:
        Notes(StorageNotesPlugin *storageNotes, QWidget *parent = 0);
        ~Notes();
        void setAccount(int acc);

private:
        Ui::Notes ui_;
        int account_;
        StorageNotesPlugin *storageNotes_;
        TagModel *tagModel_;
        NoteModel *noteModel_;
        ProxyModel *proxyModel_;
        void updateTags();
        QString replaceSymbols(QString str);
        bool newNotes;

public slots:
        void incomingNotes(QList<QDomElement> notes);
        void load();
        void error();

private slots:
        void save();
        void add();
        void del();
        void edit();
        void addNote(QDomElement note);
        void noteEdited(QDomElement note, QModelIndex index);
        void selectTag();

protected:
        void closeEvent(QCloseEvent * event);
        void keyPressEvent(QKeyEvent *e);
};


#endif // NOTES_H
