#include "tagsmodel.h"

int TagModel::rowCount(const QModelIndex &/*parent*/) const
 {
     return stringList.count();
 }

QVariant TagModel::data(const QModelIndex &index, int role) const
 {
     if (!index.isValid())
         return QVariant();

     if (index.row() >= stringList.size())
         return QVariant();

     if (role == Qt::DisplayRole)
         return stringList.at(index.row());
     else
         return QVariant();
 }

void TagModel::addTag(QString tag)
{
    if(stringList.contains(tag))
        return;
     beginInsertRows(QModelIndex(), stringList.size(), stringList.size());
     stringList.append(tag);
     endInsertRows();
}

void TagModel::removeTag(QString tag)
{
     if(!stringList.contains(tag))
           return;

     int i = stringList.indexOf(tag);
     if(i == -1)
         return;

     beginRemoveRows(QModelIndex(), i, i);
     stringList.removeAt(i);
     endRemoveRows();
}

void TagModel::clear()
{
    stringList.clear();
    reset();
}

QModelIndex TagModel::indexByTag(QString tag) const
{
    const QModelIndex index = this->index(0);
    int row = stringList.indexOf(tag);
    if(row == -1)
        return index;

    return this->index(row);
}





////--------NoteModel---------------------
NoteModel::NoteModel(QObject *parent) : QAbstractListModel(parent)
{  
}

int NoteModel::rowCount(const QModelIndex &/*parent*/) const
 {
     return notesList.count();
 }

QVariant NoteModel::data(const QModelIndex &index, int role) const
 {
     if (!index.isValid())
         return QVariant();

     if (index.row() >= notesList.size())
         return QVariant();

     if(role == Qt::DisplayRole){         
         QDomElement note = notesList.at(index.row());
         QString textNote;
         QString tag = note.attribute("tags");
         QString text = note.firstChildElement("text").text();
         QString title = note.firstChildElement("title").text();
         if(!title.isEmpty())
              textNote += tr("Title: %1").arg(title);
         if(!tag.isEmpty())
             textNote += tr("\nTags: %1").arg(tag);
         if(!text.isEmpty())
             textNote += "\n"+text;

         return textNote.isEmpty() ? QVariant() : QVariant(textNote);
     }
     else if (role == NoteRole) {
         QDomElement note = notesList.at(index.row());
         return QVariant(note.firstChildElement("text").text());
     }
     else if(role == TagRole) {
         QDomElement note = notesList.at(index.row());
         return QVariant(note.attribute("tags"));
     }
     else if(role == TitleRole) {
         QDomElement note = notesList.at(index.row());
         return QVariant(note.firstChildElement("title").text());
     }
     else
         return QVariant();
 }

 void NoteModel::clear()
 {
     notesList.clear();
     reset();
 }

 void NoteModel::editNote(QDomElement note, const QModelIndex &index)
 {
     delNote(index);
     insertNote(note, index);
 }

 void NoteModel::addNote(QDomElement note)
 {
     beginInsertRows(QModelIndex(), notesList.size(), notesList.size());
     notesList.append(note);
     endInsertRows();
 }

 void NoteModel::insertNote(QDomElement note, const QModelIndex &index)
 {
     if (!index.isValid())
         return;

     beginInsertRows(QModelIndex(), index.row(), index.row());
     notesList.insert(index.row(), note);
     endInsertRows();
 }

 void NoteModel::delNote(const QModelIndex &index)
 {
      if (!index.isValid())
         return;

     if (index.row() >= notesList.size())
         return;

     beginRemoveRows(QModelIndex(), index.row(), index.row());
     notesList.removeAt(index.row());
     endRemoveRows();
 }

 QList<QDomElement> NoteModel::getAllNotes()
 {
     return notesList;
 }

 QStringList NoteModel::getAllTags()
 {
     QStringList tagsList;
     foreach(QDomElement note, notesList) {
         QStringList tags = note.attribute("tags").split(" ", QString::SkipEmptyParts);
         tagsList += tags;
     }
     return tagsList;
 }



 /////-------------ProxyModel---------------

  bool ProxyModel::filterAcceptsRow(int sourceRow, const QModelIndex &parent) const
 {
    QModelIndex index = sourceModel()->index(sourceRow, 0, parent);
    QString filter = filterRegExp().pattern();
    if(QString("All Tags").contains(filter))
        return true;

    QStringList tags = index.data(NoteModel::TagRole).toString().split(" ");
    return  tags.contains(filter);
 }

