#ifndef DELEGATE_H
#define DELEGATE_H

#include <QItemDelegate>
#include <QPainter>

#include "iconfactoryaccessinghost.h"

class IconDelegate : public QItemDelegate
{
    Q_OBJECT

    public:
            IconDelegate(IconFactoryAccessingHost *iconHost, QObject * parent = 0)  : QItemDelegate(parent), iconHost_(iconHost) {};
            virtual QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;
            virtual void drawDisplay(QPainter * /*painter*/, const QStyleOptionViewItem & /*option*/, const QRect & /*rect*/, const QString & /*text*/) const {};
            void paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const;

    private:
            IconFactoryAccessingHost *iconHost_;

};

class LineEditDelegate : public QItemDelegate
{
    Q_OBJECT

    public:
            LineEditDelegate(QObject * parent = 0)  : QItemDelegate(parent) {};
            QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;
            void setEditorData(QWidget *editor, const QModelIndex &index) const;
            void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
           // void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const;
};

#endif // DELEGATE_H
