#include"dwtest.h"

#include<qapplication.h>
#include<qfile.h>

DwTest::DwTest(const QStringList &dirs)
{
	for(QStringList::ConstIterator it = dirs.begin(); it != dirs.end(); ++it) {
		DirWatch *dw = new DirWatch(*it, this);
		connect(dw, SIGNAL(changed()), SLOT(dw_changed()));
	}
}

void DwTest::dw_changed()
{
	DirWatch *dw = (DirWatch *)sender();
	printf("[%s] changed\n", dw->dir().latin1());
}


int main(int argc, char **argv)
{
	QApplication app(argc, argv);

	if(argc < 2) {
		printf("usage: dwtest dir1 dir2 ...\n\n");
		return 0;
	}

	QStringList dirList;
	for(int n = 1; n < argc; ++n) {
		QString dir = QFile::decodeName(argv[n]);
		dirList += dir;
	}

	DwTest *test = new DwTest(dirList);
	app.exec();
	delete test;

	return 0;
}

