/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include "common.h"

void TipUI::init()
{
#ifdef Q_WS_MAC
	lb_icon->setIcon(0);
#endif

	setCaption( CAP(caption()) );
	//ck_showTips->hide();

	// add useful tips here
	addTip( tr("Hello! Thank you for downloading Psi!\nWe hope that you will enjoy using it as we have enjoyed making it!\n"
		   "<br><br>If you want to download another language translation, iconset or a new version of Psi, then you need to visit the <a href=\"http://psi.affinix.com\">Psi HomePage</a>.\n"
		   "<br><br>If you think, that you have found a bug or you just want to chat with other Psi users, then visit the <a href=\"http://psi.affinix.com/forums/\">Psi Forums</a>.\n"
		   "<br><br><div align=\"right\"><i>the Psi Team</i></div>"), "" );
	addTip( tr("You can select multiple emoticon iconsets, and assign them priorities using the options dialog."), "" );
	addTip( tr("You can use multiple useful shortcuts while typing chat messages:<br>\n"
		   "<ul>\n"
		   "<li>Ctrl+Enter to send message</li>\n"
		   "<li>Ctrl+M to add newline character</li>\n"
		   "<li>Ctrl+H to display message history dialog</li>\n"
		   "<li>Alt+S to send message</li>\n"
		   "<li>Ctrl+U to clear edit buffer</li>\n"
		   "<li>Ctrl+PgUp/PgDn to scroll chat view</li>\n"
		   "</ul>"), "" );
	addTip( tr("You can type these special commands in chat and groupchat dialogs:\n"
		   "<ul>\n"
		   "<li>\"/clear\" to clear chat view</li>\n"
		   "<li>\"/me &lt;message&gt;\" '/me' is replaced by your nick</li>\n"
		   "</ul>\n"
		   "And these work only in groupchat dialog:\n"
		   "<ul>\n"
		   "<li>\"/nick &lt;new_nickname&gt;\" to change your nickname</li>\n"
		   "</ul>"), "" );
	addTip( tr("Did you know that you can register multiple Jabber accounts with Psi? If you like to separate your work from your personal account, you can.  If you are a power user who wants to test the latest Jabber features on an unstable server, you can do that -- without running a second client to connect to your stable server.  Just click Add in the Account Setup screen."),
		"Hal Rottenberg" );
	addTip( tr("Do you chat on third-party IM networks such as AIM and ICQ?  Try enabling the \"transport-specific icons\" option.  This will allow you to quickly see at a glance which network your buddy is using.  Then you can convince him to switch to Jabber. <icon name=\"psi/smile\">"),
		"Hal Rottenberg" );
	addTip( tr("Did you know that you can use checkboxes in Account Setup dialog to enable/disable accounts? This may be useful in the case of an account that you use rarely, so it will not clutter your roster."),
		"Iain MacDonnell" );
	addTip( tr("Don't like the buttons where they are?  Want a shortcut button to change your status to Away?  Check out the Configure Toolbars window, it's available through toolbars' context menu.  You can even make a toolbar that floats!"),
		"Hal Rottenberg" );
	addTip( tr("Did you know that Psi is one of the only Jabber clients that allows you to connect to multiple servers at the same time?  You can be known as \"mrcool@jabber.org\" to your friends, and \"John.J.Smith_the_fourth@mycompany.com\" to business associates."),
		"Hal Rottenberg" );
	addTip( tr("Have you converted over from Gadu-Gadu or Trillian and you miss the cool emoticons?  Fear not, we have you covered!  Check out <a href=\"http://jisp.netflint.net\">http://jisp.netflint.net</a> for tons of \"Iconsets\" that can be added to Psi to make it look the way you like!"),
		"Hal Rottenberg" );
	addTip( tr("Did you know that a middle-click (the middle mouse button on a 3-button mouse) will \"perform the default action\" on many objects within Psi?  Try middle-clicking on a contact or a popup."),
		"Hal Rottenberg" );
	addTip( tr("In order to add contacts from different IM networks, you need to add a corresponding agent from your Jabber server. Take a look at Psi Menu -> Service Discovery."),
		"Philipp Droessler" );
	addTip( tr("You can right-click on the server name in your roster to perform several different actions.  You can change status, modify account settings, perform administrative options (if you have permission), and more."),
		"Hal Rottenberg" );
	addTip( tr("Looking for a transport or chatroom, but your server provides nothing appropriate? Use Psi Menu -> Service Discovery to look on <i>any</i> Jabber Server for nice services by typing its domain in the address field.\n<br><br>\nNote: Some server may disable transport registration to users from different servers, but that's not common yet."),
		"Patrick Hanft" );

	// this MUST be the last tip
	addTip( tr("This is the last tip.\n<br><br>If you want to contribute your own \"tip of the day\", please publish it on the <a href=\"http://psi.affinix.com/forums\">Psi Forums</a> (or mail it to the one of the developers), and we'll be happy to integrate it for the next release."), "" );

	updateTip();
	ck_showTips->setChecked( option.showTips );
}


void TipUI::updateTip()
{
	if ( option.tipNum < 0 )
		option.tipNum = tips.count() - 1;
	if ( option.tipNum >= (int)tips.count() )
		option.tipNum = 0;

	tv_psi->setText( tips[option.tipNum] );

	option.tipNum++;
}


void TipUI::next()
{
	updateTip();
}


void TipUI::previous()
{
	option.tipNum -= 2;
	updateTip();
}


void TipUI::showTipsChanged( bool e )
{
	option.showTips = e;
}


void TipUI::addTip( QString tip, QString author )
{
	QString t = tip;
	if ( !author.isEmpty() )
		t += "<br><br><i>" + tr("Contributed by") + " " + author + "</i>";

	tips += t;
}
