
answers = {}

# HBC6 (HBC6A)
answers['hbc'] = {
'PBE': 0.54, 
'PBED2': 1.45,
'B3LYP': 1.27,
'B3LYPD2': 0.94,
'B97': 1.37,
'B97D2': 0.39,
'B97D3BJ': 0.77,
'VV10': 1.13,
'LCVV10': 1.25,
'WB97XD': 0.61,
'WB97XV': 0.39,
'M06L': 0.36,
'M06': 0.31,
'M062X': 0.59,
'M11L': 0.68,
'M11': 0.46,
}

# NBC10A1 Parallel-displaced (3.4), sandwich, and T-shaped benzene dimer PECs
answers['nbca1'] = {
'PBE': 3.29, 
'PBED2': 0.19,
'B3LYP': 4.77,
'B3LYPD2': 0.26,
'B97': 3.98,
'B97D2': 0.67,
'B97D3BJ': 0.20,
'VV10': 0.27,
'LCVV10': 0.15,
'WB97XD': 0.41,
'WB97XV': 0.23,
'M06L': 0.26,
'M06': 0.58,
'M062X': 0.43,
'M11L': 0.47,
'M11': 0.69,
}
# S22 (S22B)
answers['s22'] = {
'PBE': 3.50, 
'PBED2': 0.70,
'B3LYP': 4.74,
'B3LYPD2': 0.74,
'B97': 4.25,
'B97D2': 0.60,
'B97D3BJ': 0.54,
'VV10': 0.63,
'LCVV10': 0.51,
'WB97XD': 0.41,
'WB97XV': 0.23,
'M06L': 0.43,
'M06': 0.77,
'M062X': 0.47,
'M11L': 0.91,
'M11': 0.58,
}
# S66x8
answers['s66x8'] = {
'PBE': 2.19, 
'PBED2': 0.64,
'B3LYP': 3.17,
'B3LYPD2': 0.65,
'B97': 2.73,
'B97D2': 0.35,
'B97D3BJ': 0.43,
'VV10': 0.50,
'LCVV10': 0.34,
'WB97XD': 0.44,
'WB97XV': 0.22,
'M06L': 0.31,
'M06': 0.48,
'M062X': 0.35,
'M11L': 0.83,
'M11': 0.42,
}
# S66
answers['s66'] = {
'PBE': 2.59, 
'PBED2': 0.63,
'B3LYP': 3.71,
'B3LYPD2': 0.62,
'B97': 3.16,
'B97D2': 0.36,
'B97D3BJ': 0.52,
'VV10': 0.52,
'LCVV10': 0.31,
'WB97XD': 0.52,
'WB97XV': 0.18,
'M06L': 0.36,
'M06': 0.53,
'M062X': 0.29,
'M11L': 0.81,
'M11': 0.41,
}
# S22by5
answers['s22x5'] = {
'PBE': 2.91,
'PBED2': 0.65,
'B3LYP': 3.99,
'B3LYPD2': 0.61,
'B97': 3.64,
'B97D2': 0.71,
'B97D3BJ': 0.40,
'VV10': 0.59,
'LCVV10': 0.48,
'WB97XD': 0.43,
'WB97XV': 0.41,
'M06L': 0.42,
'M06': 0.80,
'M062X': 0.47,
'M11L': 0.94,
'M11': 0.55,
}
# HTBH38
answers['htbh'] = {
'PBE': 9.97,
'PBED2': 10.57,
'B3LYP': 4.81,
'B3LYPD2': 5.49,
'B97': 4.53,
'B97D2': 5.12,
'B97D3BJ': 7.63,
'VV10': 9.22,
'LCVV10': 1.50,
'WB97XD': 2.57,
'WB97XV': 2.28,
'M06L': 4.62,
'M06': 2.21,
'M062X': 1.26,
'M11L': 1.86,
'M11': 1.68,
}
# NHTBH38
answers['nhtbh'] = {
'PBE': 10.20,
'PBED2': 10.53,
'B3LYP': 5.41,
'B3LYPD2': 5.84,
'B97': 3.83,
'B97D2': 4.15,
'B97D3BJ': 7.12,
'VV10': 10.79,
'LCVV10': 3.38,
'WB97XD': 1.73,
'WB97XV': 1.64,
'M06L': 4.79,
'M06': 2.64,
'M062X': 1.69,
'M11L': 3.72,
'M11': 1.49,
}
# A24
answers['a24'] = {
'PBE': 0.46,
'PBED2': 0.59,
'B3LYP': 1.05,
'B3LYPD2': 0.39,
'B97': 0.75,
'B97D2': 0.26,
'B97D3BJ': 0.32,
'VV10': 0.41,
'LCVV10': 0.15,
'WB97XD': 0.15,
'WB97XV': 0.09,
'M06L': 0.23,
'M06': 0.25,
'M062X': 0.28,
'M11L': 0.46,
'M11': 0.27,
}
# X40
answers['x40'] = {
'PBE': 1.63,
'PBED2': 0.74,
'B3LYP': 2.48,
'B3LYPD2': 0.47,
'B97': 2.08,
'B97D2': 0.43,
'B97D3BJ': 0.59,
'VV10': 0.63,
'LCVV10': 0.41,
'WB97XD': 0.49,
'WB97XV': 0.21,
'M06L': 0.48,
'M06': 0.57,
'M062X': 0.28,
'M11L': 1.23,
'M11': 0.54,
}
# CYCONF
answers['cyconf'] = {
'PBE': 0.95,
'PBED2': 0.98,
'B3LYP': 0.53,
'B3LYPD2': 0.32,
'B97': 0.49,
'B97D2': 0.37,
'B97D3BJ': 0.56,
'VV10': 0.57,
'LCVV10': 0.78,
'WB97XD': 0.41,
'WB97XV': 0.11,
'M06L': 0.39,
'M06': 0.16,
'M062X': 0.30,
'M11L': 0.57,
'M11': 0.51,
}
# NBC10A2
answers['nbca2'] = {
'PBE': 0.91,
'PBED2': 0.28,
'B3LYP': 1.51,
'B3LYPD2': 0.20,
'B97': 1.19,
'B97D2': 0.08,
'B97D3BJ': 0.08,
'VV10': 0.05,
'LCVV10': 0.12,
'WB97XD': 0.13,
'WB97XV': 0.09,
'M06L': 0.15,
'M06': 0.28,
'M062X': 0.11,
'M11L': 0.54,
'M11': 0.16,
}
# NBC10A3
answers['nbca3'] = {
'PBE': 2.57,
'PBED2': 0.28,
'B3LYP': 3.77,
'B3LYPD2': 0.29,
'B97': 3.20,
'B97D2': 0.54,
'B97D3BJ': 0.19,
'VV10': 0.17,
'LCVV10': 0.06,
'WB97XD': 0.27,
'WB97XV': 0.37,
'M06L': 0.47,
'M06': 0.69,
'M062X': 0.63,
'M11L': 0.83,
'M11': 0.80,
}

#------
#'PBE': 
#'PBED2': 
#'B3LYP': 
#'B3LYPD2': 
#'B97': 
#'B97D2': 
#'B97D3BJ': 
#'VV10': 
#'LCVV10': 
#'WB97XD': 
#'WB97XV': 
#'M06L': 
#'M06': 
#'M062X': 
#'M11L': 
#'M11': 

# ************************************

import qcdb

def testem(odb, ss, bm, ans):
    dbse = odb.dbse
    print """<<<  {} {} {}  >>>""".format(dbse, ss.lower(), bm.upper())
    for mtd in active_methods:
        pub = ans[mtd]
        perr = odb.compute_statistics(mtd + mode, benchmark=bm, sset=ss)
        qcdb.compare_values(pub, perr[dbse][err], digits, dbse + ' @ ' + mtd, exitonfail=False)
    print ''

err = 'rmse'
digits = 0.02
mode = '-unCP-atz'
active_methods = ['PBE', 'B3LYP', 'VV10', 'LCVV10', 'WB97XD', 'WB97XV', 'M062X', 'M11L', 'M11']

print """\n<<<  Mardirossian:2014:9904  PCCP 2014, 16, 9904  >>>\n"""

asdf = qcdb.Database('s22')
asdf.load_qcdata_byproject('dhdft')
testem(odb=asdf, ss='default', bm='S22B', ans=answers['s22'])

asdf = qcdb.Database('hbc6')
asdf.load_qcdata_byproject('dhdft')
testem(odb=asdf, ss='default', bm='HBC6A', ans=answers['hbc'])

asdf= qcdb.Database('nbc10')
asdf.load_qcdata_byproject('dhdft')
asdf.add_Subset_union('a1', ['bzbz_pd34', 'bzbz_t', 'bzbz_s'])
asdf.add_Subset_union('a2', ['meme', 'bzme'])
asdf.add_Subset_union('a3', ['pypy_s2', 'pypy_t3'])
testem(odb=asdf, ss='a1', bm='NBC10A', ans=answers['nbca1'])
testem(odb=asdf, ss='a2', bm='NBC10A', ans=answers['nbca2'])
testem(odb=asdf, ss='a3', bm='NBC10A', ans=answers['nbca3'])

