#include <string.h>
#include "ps_intern.h"

#define NUM_INPUTENCODINGS 4

ENCODING inputencoding[NUM_INPUTENCODINGS] = {{
	"ISO-8859-1",
	{"", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand",
	 "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash",
	 "zero", "one", "two", "three", "four", "five", "six", "seven",
	 "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question",
	 "at", "A", "B", "C", "D", "E", "F", "G",
	 "H", "I", "J", "K", "L", "M", "N", "O",
	 "P", "Q", "R", "S", "T", "U", "V", "W",
	 "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore",
	 "quoteleft", "a", "b", "c", "d", "e", "f", "g",
	 "h", "i", "j", "k", "l", "m", "n", "o",
	 "p", "q", "r", "s", "t", "u", "v", "w",
	 "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	 "dotlessi", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent",
	 "dieresis", "", "ring", "cedilla", "", "hungarumlaut", "ogonek", "caron",
	 "space", "exclamdown", "cent", "sterling", "Euro", "yen", "brokenbar", "section",
	 "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron",
	 "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered",
	 "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown",
	 "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla",
	 "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis",
	 "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply",
	 "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls",
	 "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla",
	 "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis",
	 "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide",
	 "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis" } },
	{"ISO-8859-2",
	{"", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand",
	 "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash",
	 "zero", "one", "two", "three", "four", "five", "six", "seven",
	 "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question",
	 "at", "A", "B", "C", "D", "E", "F", "G",
	 "H", "I", "J", "K", "L", "M", "N", "O",
	 "P", "Q", "R", "S", "T", "U", "V", "W",
	 "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore",
	 "quoteleft", "a", "b", "c", "d", "e", "f", "g",
	 "h", "i", "j", "k", "l", "m", "n", "o",
	 "p", "q", "r", "s", "t", "u", "v", "w",
	 "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "",
	 "", "", "", "", "", "", "", "",
	 "", "", "", "", "", "", "", "",
	 "dotlessi", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent",
	 "dieresis", "", "ring", "cedilla", "", "hungarumlaut", "ogonek", "caron",
	 "space", "Aogonek", "breve", "Lslash", "currency", "Lcaron", "Sacute", "section",
	 "dieresis", "Scaron", "Scedilla", "Tcaron", "Zacute", "hyphen", "Zcaron", "Zdotaccent",
	 "ring", "aogonek", "ogonek", "lslash", "acute", "lcaron", "sacute", "caron",
	 "cedilla", "scaron", "scedilla", "tcaron", "zacute", "hungarumlaut", "zcaron", "zdotaccent",
	 "Racute", "Aacute", "Acircumflex", "Abreve", "Adieresis", "Lacute", "Cacute", "Ccedilla",
	 "Ccaron", "Eacute", "Eogonek", "Edieresis", "Ecaron", "Iacute", "Icircumflex", "Dcaron",
	 "Dcroat", "Nacute", "Ncaron", "Oacute", "Ocircumflex", "Ohungarumlaut", "Odieresis", "multiply",
	 "Rcaron", "Uring", "Uacute", "Uhungarumlaut", "Udieresis", "Yacute", "Tcommaaccent", "germandbls",
	 "racute", "aacute", "acircumflex", "abreve", "adieresis", "lacute", "cacute", "ccedilla",
	 "ccaron", "eacute", "eogonek", "edieresis", "ecaron", "iacute", "icircumflex", "dcaron",
	 "dcroat", "nacute", "ncaron", "oacute", "ocircumflex", "ohungerumlaut", "odieresis", "divide",
	 "rcaron", "uring", "uacute", "uhungarumlaut", "udieresis", "yacute", "tcommaaccent", "dotaccent" } },
	 {NULL, NULL},
	 {NULL, NULL}
	};

ENCODING *ps_get_inputencoding(const char *name) {
	int i;

	for(i=0; i<NUM_INPUTENCODINGS; i++) {
#ifdef WIN32
		if(0 == _stricmp(name, inputencoding[i].name)) {
#else
		if(0 == strcasecmp(name, inputencoding[i].name)) {
#endif
			return(&inputencoding[i]);
		}
	}
	return(NULL);
}

