package PSP::ProcManager;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: ProcManager.pm,v 1.4 2001/02/12 21:30:08 hartmans Exp $

use strict;
use FCGI::ProcManager;
use PSP::Log qw(&psp_warn &psp_die);
use PSP::Conf qw($psp_processes_to_spawn);

BEGIN {
  @PSP::ProcManager::ISA = qw(FCGI::ProcManager);
}

=head1 NAME

 PSP::ProcManager - a PSP-specific sub-class of FCGI::ProcManager

=head1 SYNOPSIS

 # In its simplest form.
 use CGI::Fast;
 use PSP::ProcManager;
 ...

=head1 DESCRIPTION

PSP::ProcManager is used to serve as a ProcManager process manager.  
The parent uses fork(2) and wait(2) to manage a set of ProcManager servers.

=head1 SUBROUTINES

=cut

sub new {
  my ($proto,$init) = @_;
  $init ||= {};

  if (!defined $init->{n_processes} and defined $psp_processes_to_spawn) {
    $init->{n_processes} = $psp_processes_to_spawn;
  }

  return $proto->SUPER::new($init);
}

sub pm_notify {
  my ($this,$msg) = @_;
  psp_warn($msg);
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<PSP::Conf>, L<PSP::Log>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
