# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.
#
# $Id: perlxs.mk,v 1.1 2000/11/23 23:36:21 muaddib Exp $
#
# Usage:
# include this fragment in a Makefile that
# builds a perl extention;
# you will probably want to include
# $(XS_PERL_ARCHLIB)/CORE in $(LOCAL_INCLUDES)
#
# If you include both obj.mk and cpp.mk
# you will need to disambiguate whether the extention is c++ or c
# with explicit dependencies.

XS_PERL_LIB:=$(shell $(perl)  -mConfig -e'print $$Config::Config{privlibexp}')
XS_PERL_ARCHLIB:= $(shell $(perl) -mConfig -e 'print $$Config::Config{archlibexp}')
XSUBPP_DIR = $(XS_PERL_LIB)/ExtUtils
XSUBPP_ARGS = -prototypes -typemap $(XSUBPP_DIR)/typemap 

%.c: %.xs
	$(perl) $(XSUBPP_DIR)/xsubpp $(XSUBPP_ARGS) $< >$@.tmp&&mv $@.tmp $@

%.cpp: %.xs
	$(perl) $(XSUBPP_DIR)/xsubpp -C++ $(XSUBPP_ARGS)   $< >$@.tmp&&mv $@.tmp $@

