/* *************************************************************************
  Module:        lexalignpop.c   
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Routines for 'Align Cartridges' popup window.
  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <stdio.h>
#include <gtk/gtk.h>
#include "lexgui.h"

/* Values of scale widget defaults */
int scale_value[4] = {15, 7, 15, 15};
/* -------------------------------------------------------------------------
        scale_CB()
   ------------------------------------------------------------------------- */
void scale_CB(GtkAdjustment *adj, gint *indx)
{
  scale_value[*indx] = (int)adj->value;
}
/* -------------------------------------------------------------------------
        align_CB()
   ------------------------------------------------------------------------- */
void align_CB(GtkWidget *w, msgbox_struct *m)
{
  char message[50];

  clear_msgbox(m); /* clear immediately */
  if(!opendev(m, 2))
  {
    sprintf(message, "%s", "Printing an alignment page...");
    put_msg(m, message, GREEN, 0);
    print_alignment(m);
    clear_message(m); /* clear with timer */
  }
  closedev();
}
/* -------------------------------------------------------------------------
        sendalign_CB()
   ------------------------------------------------------------------------- */
void sendalign_CB(GtkWidget *w, msgbox_struct *m)
{
  char message[50];

  clear_msgbox(m); /* clear immediately */
  if(!opendev(m, 2))
  {
    sprintf(message, "%s", "Sent the alignment info.");
    put_msg(m, message, GREEN, 0);
    send_alignment(scale_value, m);
    clear_message(m); /* clear with timer */
  }
  closedev();
} 
/* -------------------------------------------------------------------------
        make_scale()
   ------------------------------------------------------------------------- */
void make_scale(GtkWidget *hbox, int init_setting, int min, int max, int *indx)
{
  GtkObject *adjustment;
  GtkWidget *scale;

  adjustment = gtk_adjustment_new(init_setting, min, max, 1, 1, 0);
  gtk_signal_connect (GTK_OBJECT (adjustment), "value_changed",
                      GTK_SIGNAL_FUNC (scale_CB), (gpointer)indx);
  scale = gtk_hscale_new(GTK_ADJUSTMENT(adjustment));
  gtk_scale_set_digits(GTK_SCALE(scale), 0);
  gtk_box_pack_start(GTK_BOX(hbox), scale, FALSE, FALSE, 0);
  gtk_widget_show(scale);
}
/* -------------------------------------------------------------------------
        make_button() Returns button with left justified label. Pass 
                      in the box to put it in and the string to use
                      for the label. Does not do an event handler
                      (gtk_signal_connect).
   ------------------------------------------------------------------------- */
GtkWidget *make_button(GtkWidget *box, char *label_str)
{
  GtkWidget *button, *hbox, *blabel;

  /* button is as long as longest sentence below */
  button = gtk_button_new();
  gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
  gtk_widget_show(button);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(button), hbox);
  gtk_widget_show(hbox);

  /* added above hbox to allow left-justification of the following label */
  blabel = gtk_label_new(label_str);
  gtk_label_set_justify(GTK_LABEL(blabel), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(hbox), blabel, FALSE, FALSE, 0);
  gtk_widget_show(blabel);

  return(button);
}
/* -------------------------------------------------------------------------
        align_window()
   ------------------------------------------------------------------------- */
void align_window(int alreadyopen, topwin_struct *top)
{
  static task_struct alignw;
  GtkWidget *hbox, *button, *label;
  char label_str[64];
  GtkWidget *draftbox, *pixmapwidget;
  extern int devtype;
  static gint index[4] = {0, 1, 2, 3};

  init_task(top, &alignw);
  popup_window(&alignw, "Align Cartridges");

  /* For the drafting pixmap at the top, added at the end of this function */
  draftbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(alignw.vbox_top), draftbox, FALSE, FALSE, 0);
  gtk_widget_show(draftbox);
  make_separator(alignw.vbox_top);

  /*---------------------- Step 1 ----------------------------*/ 
  sprintf(label_str, "%s", "Step 1: Press to print alignment page.");
  button = make_button(alignw.vbox_top, label_str);
  gtk_signal_connect(GTK_OBJECT (button), "clicked",
                     GTK_SIGNAL_FUNC (align_CB), (gpointer)&(alignw.msgbox));
  make_separator(alignw.vbox_top);
  /*---------------------- Step 2 ----------------------------*/ 
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(alignw.vbox_top), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  /* added above hbox to allow left-justification of the following label */
  label = gtk_label_new("Step 2: Examine the printed results.");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  make_separator(alignw.vbox_top);
  /*---------------------- Step 3 ----------------------------*/ 
  /* long label, so hbox and left-justify not needed. */
  label = gtk_label_new("Step 3: Select the best alignment number for A:");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label); 

  make_scale(alignw.vbox_top, scale_value[0], 0, 30, &(index[0]));
  make_separator(alignw.vbox_top);
  /*---------------------- Step 4 ----------------------------*/ 
  /* long label, so hbox and left-justify not needed. */
  label = gtk_label_new("Step 4: Select the best alignment number for B:");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  make_scale(alignw.vbox_top, scale_value[1], 0, 15, &(index[1]));
  make_separator(alignw.vbox_top);
  /*---------------------- Step 5 ----------------------------*/ 
  /* long label, so hbox and left-justify not needed. */
  label = gtk_label_new("Step 5: Select the best alignment number for C:");
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  label = gtk_label_new("(Not used for photo cartridges.)");
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  make_scale(alignw.vbox_top, scale_value[2], 0, 30, &(index[2]));
  make_separator(alignw.vbox_top);
  /*---------------------- Step 6 ----------------------------*/ 
   /* long label, so hbox and left-justify not needed. */
  label = gtk_label_new("Step 6: Select the best alignment number for D:");
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  label = gtk_label_new("(Not used for photo cartridges.)");
  gtk_box_pack_start (GTK_BOX (alignw.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  make_scale(alignw.vbox_top, scale_value[3], 0, 30, &(index[3]));
  make_separator(alignw.vbox_top);
  /*---------------------- Step 7 ----------------------------*/ 
  sprintf(label_str, "%s", "Step 7: Press to send alignment values.");
  button = make_button(alignw.vbox_top, label_str);
  gtk_signal_connect(GTK_OBJECT (button), "clicked",
                     GTK_SIGNAL_FUNC (sendalign_CB),(gpointer)&(alignw.msgbox));
  make_separator(alignw.vbox_top);
  /*----------------------------------------------------------*/ 
  make_messageBox(&(alignw.vbox_top), &(alignw.msgbox));
  /* For the X delete */
  gtk_signal_connect(GTK_OBJECT(alignw.tasktop), "delete_event",
                     GTK_SIGNAL_FUNC(deleteTWX), (gpointer)&alignw);
  gtk_widget_show(alignw.tasktop);
  /* Add the drafting pixmap to this window */
  pixmapwidget = create_nbpix(&(alignw.tasktop), 2);
  gtk_box_pack_start(GTK_BOX(draftbox), pixmapwidget, TRUE, FALSE, 0);

  if(!devtype && alreadyopen)
    pop_set_note(&alignw, NULL);
}
