/* *************************************************************************
  Module:        lexhand.c
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Eric Harlow's code from his book,
                 used to create a hand cursor. Also
                 contains Harlow's CreateWidgetFromXpm
                 for the icons used in pup.
  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** 
                 The portions of this file extracted from
                 Eric Harlow's cursors.c from the book
                 "Developing Linux Applications with GTK+ and GDK",
                 ISBN 0-7357-0021-4
                 COPYRIGHT (c) 1999 New Riders Publishing
                 This statement appears on the copyright page:
                 "All of the code examples included in this book
                 are distributed under the terms of the General 
                 Public License."
**************************************************************************** */
#include <gtk/gtk.h>
#include <stdio.h>
#include "lexgui.h"

/* -------------------------------------------------------------------------
        create_bitmap_and_mask_from_xpm()
   ------------------------------------------------------------------------- */
void create_bitmap_and_mask_from_xpm (GdkBitmap **bitmap, 
                                      GdkBitmap **mask, gchar **xpm)
{
  int height, width, colors;
  char pixmap_buffer [(32 * 32)/8];
  char mask_buffer [(32 * 32)/8];
  int x, y, pix;
  int transparent_color, black_color;

  sscanf (xpm [0], "%d %d %d %d", &height, &width, &colors, &pix);

  g_assert (height == 32);
  g_assert (width  == 32);
  g_assert (colors == 3);

  transparent_color = ' ';
  black_color = '.';

  for (y = 0; y < 32; y++){
    for (x = 0; x < 32;){
      char value = 0, maskv = 0;

      for (pix = 0; pix < 8; pix++, x++){
        if (xpm [4+y][x] != transparent_color){
          maskv |= 1 << pix;

          if (xpm [4+y][x] != black_color){
            value |= 1 << pix;
          }
        }
      }
      pixmap_buffer [(y * 4 + x/8)-1] = value;
      mask_buffer [(y * 4 + x/8)-1] = maskv;
    }
  }
  *bitmap = gdk_bitmap_create_from_data (NULL, pixmap_buffer, 32, 32);
  *mask   = gdk_bitmap_create_from_data (NULL, mask_buffer, 32, 32);
} 
/* -------------------------------------------------------------------------
        create_hand_cursor() 
   ------------------------------------------------------------------------- */
GdkCursor* create_hand_cursor(void)
{
  static char * cursor_hand[] = {
  "32 32 3 1",
  "   c None",
  ".  c #000000",
  "+  c #FFFFFF",
  "                                ",
  "                                ",
  "            ...                 ",
  "           .+++.   ...          ",
  "           .+++.  .+++.   ...   ",
  "   ...     .+++.  .+++.  .+++.  ",
  "  .+++.    .+++. .+++.  .+++.   ",
  "   .+++.   .+++. .+++. .+++.    ",
  "    .+++.  .+++. .+++. .+++.    ",
  "     .+++. .+++..+++. .+++.     ",
  "      .+++..+++..+++. .+++.     ",
  "       .+++.+++..+++..+++.      ",
  "   ...  .++++++++++++++++.      ",
  "  .+++. .+++++++++++++++.       ",
  "  .++++..+++++++++++++++.       ",
  "   ..+++++++++++++++++++.       ",
  "     .++++++++++++++++++.       ",
  "      .+++++++++++++++++.       ",
  "       ..++++++++++++++.        ",
  "         .++++++++++++.         ",
  "          .++++++++++.          ",
  "           ..........           ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                "};
  GdkColor white = {0, 0xffff, 0xffff, 0xffff};
  GdkColor red = {0, 0xffff, 0x0000, 0x0000};
  GdkBitmap *bitmap;
  GdkBitmap *mask;
  GdkCursor *cursor;

  create_bitmap_and_mask_from_xpm (&bitmap, &mask, cursor_hand);
  cursor = gdk_cursor_new_from_pixmap (bitmap, mask, &white, &red, 16, 8);
  return(cursor);
}
/* -------------------------------------------------------------------------
        create_hand_g_cursor() modified from above, to simulate grabbing
   ------------------------------------------------------------------------- */
GdkCursor* create_hand_g_cursor(void)
{
  static char * cursor_handg[] = {
  "32 32 3 1",
  "   c None",
  ".  c #000000",
  "+  c #FFFFFF",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "            ...  ...            ",
  "        .. .+++..+++. ...       ",
  "       .++..+++..+++..+++.      ",
  "       .++..+++..+++..+++.      ",
  "      ..+++.+++..+++..+++.      ",
  "     .++.++++++++++++++++.      ",
  "    .+++.+++++++++++++++.       ",
  "    .+++.+++++++++++++++.       ",
  "    .+++++++++++++++++++.       ",
  "     .++++++++++++++++++.       ",
  "      .+++++++++++++++++.       ",
  "       ..++++++++++++++.        ",
  "         .++++++++++++.         ",
  "          .++++++++++.          ",
  "           ..........           ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                                "};
  GdkColor white = {0, 0xffff, 0xffff, 0xffff};
  GdkColor red = {0, 0xffff, 0x0000, 0x0000};
  GdkBitmap *bitmap;
  GdkBitmap *mask;
  GdkCursor *cursor;

  create_bitmap_and_mask_from_xpm (&bitmap, &mask, cursor_handg);
  cursor = gdk_cursor_new_from_pixmap (bitmap, mask, &white, &red, 16, 8);
  return(cursor);
}  
/* -------------------------------------------------------------------------
        create_thumb_cursor() modified from above, for a thumbs up cursor 
   ------------------------------------------------------------------------- */
GdkCursor* create_thumb_cursor(void)
{
  static char * thumb_xpm[] = {
  /* width height ncolors chars_per_pixel */
  "32 32 3 1",
  /* colors */
  "   s None  c None",
  ".  c  #000000",
  "a  c  #ffffff",
  /* pixels */
  "                                ",
  "                                ",
  "                                ",
  "                                ",
  "                  ..            ",
  "                 .a..           ",
  "                .aaa.           ",
  "                .aaa.           ",
  "               .aaaa.           ",
  "               .aaa..           ",
  "              .aaaa.            ",
  "             .aaaa..            ",
  "            .aaaaa.             ",
  "           .aaaaa........       ",
  "  ......  .aaaaa...aaaaa...     ",
  "  .aaa....aaaaaa.aaaaaaaaaa.    ",
  "  .aaa....aaaaaa.aaaaaaaaaa.    ",
  "  .aaa.aaaaaaaaaaaaa....aaaa.   ",
  "  .aaa.aaaaaaaaaaa...aaaaaaa.   ",
  "  .aaa.aaaaaaaa.aa.aaaaaa....   ",
  "  .aaa.aaaaaaaaaa........aaa.   ",
  "  .aaa.aaaaaaa.a.aaaaaaaaaaa.   ",
  "  .aaa.aaaaaa.aa.aaaaaaaaa...   ",
  "  .aaa.aaaaaaaaa.aaaaaa......   ",
  "  .aaa.aaaaaaaaaaa.....aaaa..   ",
  "  .aaa.aaaaaaaaaaa.aaaaaa...    ",
  "  .aaa.aaaaaaaaaaaa......a.     ",
  "  .aaa...aaaaaaaaaa.aaaaa..     ",
  "  .aaa....aaaaaaaaa.......      ",
  "  ......  ...............       ",
  "                                ",
  "                                "};
  GdkColor white = {0, 0xffff, 0xffff, 0xffff};
  GdkColor black = {0, 0x0000, 0x0000, 0x0000};
  GdkBitmap *bitmap;
  GdkBitmap *mask;
  GdkCursor *cursor;

  create_bitmap_and_mask_from_xpm (&bitmap, &mask, thumb_xpm);
  cursor = gdk_cursor_new_from_pixmap (bitmap, mask, &white, &black, 16, 8);
  return(cursor);
}
/* -------------------------------------------------------------------------
        CreateWidgetFromXpm() Returns a pixmap widget from an xpm
   ------------------------------------------------------------------------- */
GtkWidget *CreateWidgetFromXpm (GtkWidget *window, gchar **xpm_data)
{
  GdkBitmap *mask;
  GdkPixmap *pixmap_data;
  GtkWidget *pixmap_widget;
  GtkStyle *style;

  style = gtk_widget_get_style(window);
  pixmap_data = gdk_pixmap_create_from_xpm_d (
                               window->window,
                               &mask,
                               &style->bg[GTK_STATE_NORMAL],
                               (gchar **) xpm_data);

  pixmap_widget = gtk_pixmap_new (pixmap_data, mask);
  gtk_widget_show (pixmap_widget);

  return (pixmap_widget);
} 
