#  Created by Luke Kanies on 2006-11-12.
#  Copyright (c) 2006. All rights reserved.

require 'puppet'

# A module just to store the mount/unmount methods.  Individual providers
# still need to add the mount commands manually.
module Puppet::Provider::Mount
    # This only works when the mount point is synced to the fstab.
    def mount
        # Manually pass the mount options in, since some OSes *cough*OS X*cough* don't
        # read from /etc/fstab but still want to use this type.
        args = []
        if self.options and self.options != :absent
            args << "-o" << self.options
        end
        args << @resource[:name]

        if respond_to?(:flush)
            flush
        end
        mountcmd(*args)
    end

    def remount
        info "Remounting"
        if @resource[:remounts] == :true
            mountcmd "-o", "remount", @resource[:name]
        else
            unmount()
            mount()
        end
    end

    # This only works when the mount point is synced to the fstab.
    def unmount
        umount @resource[:name]
    end

    # Is the mount currently mounted?
    def mounted?
        platform = Facter["operatingsystem"].value
        name = @resource[:name]
        mounts = mountcmd.split("\n").find do |line|
            if platform == "Darwin"
                line =~ / on #{name} / or line =~ %r{ on /private/var/automount#{name}}
            else
                line =~ / on #{name} /
            end
        end
    end
end

# $Id: mount.rb 2745 2007-08-05 17:49:23Z luke $
