/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Configuration back-end.
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __CFG_H__
#define __CFG_H__
#define RCFILE ".pureadminrc"

typedef enum
{
  LOG_SYSLOG,
  LOG_CUSTOM,
  NUM_LOGMETHODS
} logmethod_t;

typedef struct conf_ 
{
  guint default_uid, default_gid;
  gchar *default_home;
  gchar *cmd_purepw;
  gchar *pwfile, *pdbfile;
  gchar *logfile;
  gint logdays;
  gboolean seen_usrdlg_welcome;
  gboolean resolve_hostnames;
  gboolean show_fam_errmsg;
  logmethod_t logmethod;
} cfg_t;

extern cfg_t cfg;

void cfg_set_defaults (void);
gboolean cfg_read_settings ();
gboolean cfg_write_settings ();

#endif /* __CFG_H__ */
