/* 
    SIMD functionality for Intel SSE with GCC compiler
    added by T.Grill
*/

#ifndef __M_SIMD_SSE_GCC_H
#define __M_SIMD_SSE_GCC_H

#include "m_pd.h"

/* SIMD functions for SSE with GCC */
t_int *zero_perf_sse_gcc(t_int *w);
t_int *copy_perf_sse_gcc(t_int *w);
t_int *sig_tilde_perf_sse_gcc(t_int *w);
t_int *plus_perf_sse_gcc(t_int *w);
t_int *scalarplus_perf_sse_gcc(t_int *w);
t_int *minus_perf_sse_gcc(t_int *w);
t_int *scalarminus_perf_sse_gcc(t_int *w);
t_int *times_perf_sse_gcc(t_int *w);
t_int *scalartimes_perf_sse_gcc(t_int *w);
t_int *sqr_perf_sse_gcc(t_int *w);
t_int *over_perf_sse_gcc(t_int *w);
t_int *scalarover_perf_sse_gcc(t_int *w);
t_int *max_perf_sse_gcc(t_int *w);
t_int *scalarmax_perf_sse_gcc(t_int *w);
t_int *min_perf_sse_gcc(t_int *w);
t_int *scalarmin_perf_sse_gcc(t_int *w);
t_int *clip_perf_sse_gcc(t_int *w);
t_int *sigwrap_perf_sse_gcc(t_int *w);
t_int *sigsqrt_perf_sse_gcc(t_int *w);
t_int *sigrsqrt_perf_sse_gcc(t_int *w);


/* functions in d_ugen.c */
#define zero_perf_simd          zero_perf8 /* SIMD not implemented */

/* functions in d_dac.c */
#define copy_perf_simd          copy_perf8 /* SIMD not implemented */

/* functions in d_ctl.c */
#define sig_tilde_perf_simd     sig_tilde_perf8 /* SIMD not implemented */

/* functions in d_arithmetic.c */
#define plus_perf_simd          plus_perf8 /* SIMD not implemented */
#define scalarplus_perf_simd    scalarplus_perf8 /* SIMD not implemented */
#define minus_perf_simd         minus_perf8 /* SIMD not implemented */
#define scalarminus_perf_simd   scalarminus_perf8 /* SIMD not implemented */
#define times_perf_simd         times_perf8 /* SIMD not implemented */
#define scalartimes_perf_simd   scalartimes_perf8 /* SIMD not implemented */
#define sqr_perf_simd           sqr_perf8 /* SIMD not implemented */
#define over_perf_simd          over_perf8 /* SIMD not implemented */
#define scalarover_perf_simd    scalarover_perf8 /* SIMD not implemented */
#define min_perf_simd           min_perf8 /* SIMD not implemented */
#define scalarmin_perf_simd     scalarmin_perf8 /* SIMD not implemented */
#define max_perf_simd           max_perf8 /* SIMD not implemented */
#define scalarmax_perf_simd     scalarmax_perf8 /* SIMD not implemented */

/* functions in d_math.c */
#define clip_perf_simd          clip_perform  /* SIMD not implemented */
#define sigwrap_perf_simd       sigwrap_perform  /* SIMD not implemented */
#define sigsqrt_perf_simd       sigsqrt_perform  /* SIMD not implemented */
#define sigrsqrt_perf_simd      sigrsqrt_perform /* SIMD not implemented */

#endif /* __M_SIMD_SSE_GCC_H */
