#----------------------------------------------------------------------
#    ______  ________                                             
#   /  /   \/  /___  )  I  N   T   E   G   R   A   C   I   O   N  
#  /  /       /___  /   I  N   F   O   R   M   A   T   I   C   A  
# /__/__/\___/_____'    Copyright(C) 2002 by Diego Torres Milano
#
# Author: Diego Torres Milano <diego@in3.com.ar>
# $Id: Pxesconfig.pm,v 1.2 2003/07/19 05:05:46 diego Exp $
#----------------------------------------------------------------------
package Pxesconfig;
require 5.000; use strict 'vars', 'refs', 'subs';


BEGIN {
	use constant TRUE => 1;
	use constant FALSE => 0;

	use Pxesconfig::PxesconfigModel;
	use Pxesconfig::PxesconfigGUI;

	use Exporter   ();
   our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
	my ($MODEL, $VIEW);

   # set the version for version checking
   #if using RCS/CVS, this may be preferred
   $VERSION = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; # must be all one line, for MakeMaker

	@ISA         = qw(Exporter);
	@EXPORT      = qw();
	%EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],

	# your exported package globals go here,
	# as well as any optionally exported functions
	@EXPORT_OK   = qw();
}

our @EXPORT_OK;
our $VERSION;

# non-exported package globals go here
# attributes and default values
our $DEBUG;
my $MODEL;
my $VIEW;

#
# initialize package globals
#

# debug enabled
$DEBUG = 0;
$MODEL = undef;
$VIEW = undef;


sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self = {
		view => new PxesconfigGUI(),
		};

	if ( $#_ == -1 || $_[0] eq '' ) {
		# no arguments passed
		# use default values
		$self->{model} = new PxesconfigModel();
	}
	elsif ( $#_ == 0 && $_[0] ne '' ) {
		# the argument is the file name
		# this object has not been blessed, so pass self
		$self->{model} = new PxesconfigModel($_[0]);
	}
	else {
		die "Pxesconfig::new: Invalid number of arguments";
	}

	# attach the observer to the subject
	#$self->{view}->set_subject($self->{model});
	# The biggest "parche" in computer history (at least OOP)
	$Pxesconfig::MODEL = $self->{model};
	$Pxesconfig::VIEW = $self->{view};
	print STDERR "MODEL=", $Pxesconfig::MODEL, "\n"
		if $DEBUG > 4;
	print STDERR "VIEW=", $Pxesconfig::VIEW, "\n"
		if $DEBUG > 4;

	$self->{model}->attach($self->{view});

	bless $self, $class;
	return $self;
}

sub toString() {
	my $self = shift;
	my $s;

	$s .= "Pxesconfig:\n";

	$s .= $self->{view}->toString();
	$s .= $self->{model}->toString();

	return $s;
}

1;
__END__

#=======================================================================
#==== Documentation
#=======================================================================
=pod

=head1 NAME

Pxesconfig - version 0.01 Fri May 24 01:45:10 ART 2002

This is the main class

=head1 SYNOPSIS

 use Pxesconfig;
 my $p = Pxesconfig([$filename]);

=head1 DESCRIPTION

Unfortunately, the author has not yet written any documentation :-(

=head1 AUTHOR

Diego Torres Milano <diego@in3.com.ar>

=cut
