/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.scan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureScan {
    private String top;
    private boolean subdirs;
    private boolean debug = false;

    public FeatureScan(String top, boolean subdirs) {
        this.top = top;
        this.subdirs = subdirs;
    }

    public List<Bean> scan(Formatter errlog) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File topFile = new File(this.top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", this.top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result, errlog);
        } else {
            Bean fdb = new Bean(topFile);
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, List<Bean> result, Formatter errlog) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            files.add(f);
        }
        if (files.size() > 0) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                if (prev != null) {
                    String name = f.getName();
                    String stem = this.stem(name);
                    if (name.endsWith(".gbx") || name.endsWith(".gbx8")) {
                        files2.remove(f);
                    } else if (name.endsWith(".ncml")) {
                        if (prev.getName().equals(stem + ".nc")) {
                            files2.remove(prev);
                        }
                    } else if (name.endsWith(".bz2")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gz")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gzip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".zip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".Z") && prev.getName().equals(stem)) {
                        files2.remove(f);
                    }
                }
                prev = f;
            }
            for (File f : files2) {
                result.add(new Bean(f));
            }
        }
        if (this.subdirs) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory()) continue;
                this.scanDirectory(f, result, errlog);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(".");
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static void main(String[] arg) {
        FeatureScan scanner = new FeatureScan("C:/data/datasets/modis", true);
        System.out.printf("Beans found %n", new Object[0]);
        List<Bean> beans = scanner.scan(new Formatter());
        for (Bean b : beans) {
            System.out.printf(" %40s %20s %10s %10s%n", b.getName(), b.getFileType(), b.getFeatureType(), b.getFeatureImpl());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Bean {
        public File f;
        String fileType;
        String coordMap;
        FeatureType featureType;
        String ftype;
        String info;
        String ftImpl;
        Throwable problem;

        public Bean() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Bean(File f) {
            this.f = f;
            NetcdfDataset ds = null;
            if (FeatureScan.this.debug) {
                System.out.printf(" featureScan=%s%n", f.getPath());
            }
            ds = NetcdfDataset.openDataset(f.getPath());
            this.fileType = ds.getFileTypeId();
            this.setCoordMap(ds.getCoordinateSystems());
            Formatter errlog = new Formatter();
            try {
                FeatureDataset featureDataset = FeatureDatasetFactoryManager.wrap(null, ds, null, errlog);
                if (featureDataset != null) {
                    this.featureType = featureDataset.getFeatureType();
                    if (this.featureType != null) {
                        this.ftype = this.featureType.toString();
                    }
                    this.ftImpl = featureDataset.getImplementationName();
                    Formatter infof = new Formatter();
                    featureDataset.getDetailInfo(infof);
                    this.info = infof.toString();
                } else {
                    this.ftype = "FAIL: " + errlog.toString();
                }
            }
            catch (Throwable t) {
                this.ftype = "ERR: " + t.getMessage();
                this.info = errlog.toString();
                this.problem = t;
            }
            Object var8_9 = null;
            if (ds == null) return;
            try {
                ds.close();
                return;
            }
            catch (IOException ioe) {}
            return;
            {
                catch (Throwable t) {
                    this.fileType = "ERR: " + t.getMessage();
                    this.problem = t;
                    Object var8_10 = null;
                    if (ds == null) return;
                    try {
                        ds.close();
                        return;
                    }
                    catch (IOException ioe) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (ds == null) throw throwable;
                try {
                    ds.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public String getName() {
            return this.f.getPath();
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getCoordMap() {
            return this.coordMap;
        }

        public void setCoordMap(List<CoordinateSystem> csysList) {
            CoordinateSystem use = null;
            for (CoordinateSystem csys : csysList) {
                if (use == null) {
                    use = csys;
                    continue;
                }
                if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
                use = csys;
            }
            this.coordMap = use == null ? "" : "f:D(" + use.getRankDomain() + ")->R(" + use.getRankRange() + ")";
        }

        public String getFeatureType() {
            return this.ftype;
        }

        public String getFeatureImpl() {
            return this.ftImpl;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("%s%n %s%n map = '%s'%n %s%n %s%n", this.getName(), this.getFileType(), this.getCoordMap(), this.getFeatureType(), this.getFeatureImpl());
            if (this.info != null) {
                f.format("\n%s", this.info);
            }
            if (this.problem != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
                this.problem.printStackTrace(new PrintStream(bout));
                f.format("\n%s", bout.toString());
            }
            return f.toString();
        }
    }
}

