/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;

public class Variable {
    String name;
    int rank;
    int type;
    DimensionSet dimSet;
    Calibration calibration;
    boolean coordVar = false;

    Variable(String name, DimensionSet dimSet, int rank, int type, Calibration calibration) throws HdfeosException {
        if (dimSet.getSize() != rank) {
            throw new HdfeosException(" rank and DimensionSet length don't match");
        }
        this.name = name;
        this.dimSet = dimSet;
        this.type = type;
        this.rank = rank;
        this.calibration = calibration;
        if (rank == 1 && name.equalsIgnoreCase(dimSet.getElement(0).getName())) {
            this.coordVar = true;
        }
    }

    public String getName() {
        String name = this.name;
        return name;
    }

    public int getRank() {
        return this.rank;
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public boolean equals(Variable obj) {
        return this.name.equals(obj.getName());
    }

    public DimensionSet getDimSet() {
        return this.dimSet;
    }

    public NamedDimension getDim(int ii) {
        return this.dimSet.getElement(ii);
    }

    public int getNumberType() {
        return this.type;
    }

    public boolean isCoordVar() {
        return this.coordVar;
    }

    public String toString() {
        String str = "Variable:  " + this.name + "\n" + "    rank:  " + this.rank + "\n" + "    type:  " + this.type + "\n" + "  " + this.dimSet.toString() + "\n";
        return str;
    }
}

