## checkmount.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import os
import string
from os import system, environ, path, getenv, mkdir, getcwd
import threading
import time
import pyNeighborhood
from threading import Thread

class MtabThread(Thread):
    def __init__(self):
        Thread.__init__(self)
    def run(self):
        while True:
            checkmount()
        return
def fix_proc_string(line):
    parts = line.split("\\040")
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line, part], " ")
    return final_line

def checkmount():
    try:
        os.chdir("/proc")
        mtab = open('mounts', 'r')
    except:
        os.chdir("/etc")
        mtab = open('mtab', 'r')

    mtab = open('mounts', 'r')
    mtab.seek(0)
    lines = mtab.readlines()
    sharehost = []
    share = []
    host = []
    mount_point = []
    type = []

    n=0
    for num in lines:
        temp_line =  lines[n].split()
        if temp_line[2] == 'smbfs':
            sharehost.append(temp_line[0])
            mount_point.append(fix_proc_string(temp_line[1]))
            type.append("SMB")
        if temp_line[2] == 'cifs':
            sharehost.append(temp_line[0])
            mount_point.append(fix_proc_string(temp_line[1]))
            type.append("CIFS")
        n = n+1
		
    for num in sharehost:
        temp_num = num.split('/')
        share.append(temp_num[3])
        host.append(string.upper(temp_num[2]))

    #print host, share , mount_point
    return host, share , mount_point, type

def monitor():
    thr = MtabThread()
    thr.start()
    threads.append(thr)

if __name__=="__main__":
    l, m , n , t = checkmount()
    print l, m, n, t

