# Pyntor::Fortune - Display fortune quotes on image
# Copyright (C) 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *
import random

class Fortune:
	def init(self, options):
		self.pages = 1
		# FIXME!
		self.polling = 1
		# FIXME!

		self.fn = options["fortune"]

		f = open(self.fn)
		lines = f.readlines()
		f.close()

		self.quotes = []
		tmp = []
		for line in lines:
			line = line.rstrip()
			line = line.replace("\t", "        ")
			line = unicode(line, "utf-8")
			if line == "%":
				self.quotes.append(tmp)
				tmp = []
				continue
			tmp.append(line)

		self.counter = 0

	def render(self, screen, page, globalpage):
		r = random.randint(0, len(self.quotes) - 1)

		font = pygame.font.SysFont("Vera Sans", 18)
		i = 0
		x = len(self.quotes[r])
		h = 20
		for line in self.quotes[r]:
			i += 1
			f = font.render(line, 1, (255, 255, 255))
			screen.blit(f, (50, screen.get_height() - x * h + i * h - 30))

		if pygame.display.get_surface():
			pygame.display.update()

		if pygame.display.get_surface():
			self.xscreen = pygame.display.get_surface()

	def interactive(self, event):
		if event.type == KEYDOWN:
			key = event.key
			if key == K_ESCAPE or pygame.event.peek(QUIT):
				return "exit"
			if key == K_RETURN:
				return "next"

		self.counter += 1
		if self.counter == 150000:
			self.counter = 0
			return "reload"

component = Fortune()

parameters = (
	("fortune", "Fortune file to use for display", None),
)

metainfo = {
	"version": "0.1",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Fortune: display fortune cookies randomly

This component displays fortune cookies at the bottom left area of the
screen. These cookies are dynamically updated every few seconds.
Fortune files can usually be found under /usr/share/fortunes/$lang or
/usr/share/games/fortunes/$lang.

Usage: 'fortune' -fortune <fortunefile>
 Where <fortunefile> is any file containing fortune cookies

Display: yes

Interactivity: no (but contains timer events)
"""

