# -*- coding: utf-8 -*-
#
# PyTables documentation build configuration file, created by
# sphinx-quickstart on Sun Feb  7 22:29:49 2010.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('../sphinxext'))
#sys.path.insert(0, os.path.abspath('../..'))


# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.doctest', 'sphinx.ext.pngmath',
              'sphinx.ext.inheritance_diagram', 'sphinx.ext.extlinks',
              'sphinx.ext.todo', 'sphinx.ext.viewcode',
              'ipython_console_highlighting', 'numpydoc',
              ]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'PyTables'
copyright = u'2011-2012, The PyTables Governance Team'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
VERSION = open('../../VERSION').read().strip()
version = VERSION
# The full version, including alpha/beta/rc tags.
release = VERSION

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = []

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
#pygments_style = 'sphinx'
#pygments_style = 'friendly'
#pygments_style = 'bw'
#pygments_style = 'fruity'
#pygments_style = 'manni'
pygments_style = 'tango'


# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#html_theme = 'default'
#html_theme = 'altered_nature'
html_theme = 'cloud'
#html_theme = 'sphinxdoc'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}
# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
linkcolor = '#9F1E1E'
trimcolor = '#511755'
trimcolor = '#000000'

html_theme_options = {'sidebarbgcolor': 'rgba(213, 197, 229, 0.15)',
                      'sidebartextcolor': '#280941',
                      'sidebarlinkcolor': linkcolor,
                      'sidebartrimcolor': trimcolor,
                      'collapsiblesidebar': True,
                      'relbarbgcolor': '#006FFF',
                      'footerbgcolor': 'rgba(252, 255, 0, 0.125)',
                      'footertextcolor': '#504A4B',
                      'bodytrimcolor': trimcolor,
                      'linkcolor': linkcolor,
                      'textcolor': '#323039', 
                      'sectionbgcolor': '#3CAD1C',
                      #'sectiontextcolor': '#777777',
                      #'sectiontrimcolor': trimcolor, 
                      'codebgcolor': '#F1FFF0',
                      'codetextcolor': '#000000', 
                      'quotebgcolor': '#f6fcfc',
                      'rubricbgcolor': '#D00000',
                      #'min_height': 'bottom',
                      }

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ["_theme"]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = '_static/logo-pytables-small.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'images/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
html_sidebars = {
    'index': ['globaltoc.html', 'relations.html', 'sourcelink.html',
              'searchbox.html']
}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'pytablesdoc'



# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('usersguide/usersguide', 'usersguide-%s.tex' % version,
   u'PyTables User Guide', u'The PyTables Governance Team', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
latex_logo = 'usersguide/images/pytables-front-logo.pdf'

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
latex_use_parts = True

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# A dictionary that contains LaTeX snippets that override those Sphinx
# usually puts into the generated .tex files.
latex_elements = {
    'preamble': '\usepackage{bookmark,hyperref}',
}

# Documents to append as an appendix to all manuals.
#latex_appendices = [
#    'usersguide/datatypes',
#    'usersguide/condition_syntax',
#    'usersguide/parameter_files',
#    'usersguide/nested_rec_arrays',
#    'usersguide/utilities',
#    'usersguide/file_format',
#    'usersguide/bibliography',
#]

# If false, no module index is generated.
#latex_domain_indices = True

# -- Options for autodocumentation ---------------------------------------------
autodoc_member_order = "groupwise"
autoclass_content = "class"
autosummary_generate = []

# -- Options for Epub output ---------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = u'PyTables'
epub_author = u'The PyTables Governance Team'
epub_publisher = u'The PyTables Governance Team'
epub_copyright = u'2011-2012, The PyTables Governance Team'

# -- External link oOptions ----------------------------------------------------
extlinks = {
    'issue': ('https://github.com/PyTables/PyTables/issues/%s', 'gh-'),
    'irc': ('http://pytables.github.com/irc/%s.html', ''),
}
