<html>
<head>
<title>Parton Distributions</title>
<link rel="stylesheet" type="text/css" href="pythia.css"/>
<link rel="shortcut icon" href="pythia32.gif"/>
</head>
<body>

<script language=javascript type=text/javascript>
function stopRKey(evt) {
var evt = (evt) ? evt : ((event) ? event : null);
var node = (evt.target) ? evt.target :((evt.srcElement) ? evt.srcElement : null);
if ((evt.keyCode == 13) && (node.type=="text"))
{return false;}
}

document.onkeypress = stopRKey;
</script>
<?php
if($_POST['saved'] == 1) {
if($_POST['filepath'] != "files/") {
echo "<font color='red'>SETTINGS SAVED TO FILE</font><br/><br/>"; }
else {
echo "<font color='red'>NO FILE SELECTED YET.. PLEASE DO SO </font><a href='SaveSettings.php'>HERE</a><br/><br/>"; }
}
?>

<form method='post' action='PartonDistributions.php'>

<h2>Parton Distributions</h2>

The parton distributions file contains the <code>PDF</code> class. 
<code>PDF</code> is the base class, from which specific <code>PDF</code> 
classes are derived.

<p/>
The choice of which PDF to use is made by settings in the 
<code>Pythia</code> class, see <?php $filepath = $_GET["filepath"];
echo "<a href='PDFSelection.php?filepath=".$filepath."' target='page'>";?>here</a>. 
These settings also allow to access all the proton PDF's available in the
LHAPDF library [<a href="Bibliography.php" target="page">Wha05</a>]. Thus there is no need for a normal user 
to study the <code>PDF</code> class. The structure must only be understood 
when interfacing new PDF's, e.g. ones not yet found in LHAPDF. 

<h3>The PDF base class</h3>

<code>PDF</code> defines the interface that all PDF classes should respect.
The constructor requires the incoming beam species to be given:
even if used for a proton PDF, one needs to know whether the beam
is actually an antiproton. This is one of the reasons why <code>Pythia</code> 
always defines two PDF objects in an event, one for each beam.

<p/>
Once a <code>PDF</code> object has been constructed, call it <code>pdf</code>, 
the main method is <code>pdf.xf( id, x, Q2)</code>, which returns 
<i>x*f_id(x, Q2)</i>, properly taking into account whether the beam 
is an antiparticle or not.

<p/>
Whenever the <code>xf</code> member is called with a new flavour, <i>x</i> 
or <i>Q^2</i>, the <code>xfUpdate</code> member is called to do the actual 
updating. This routine may either update that particular flavour or all 
flavours at this <i>(x, Q^2)</i> point. (In the latter case the saved 
<code>id</code> value <code>idSav</code> should be set to 9.) The choice is 
to be made by the producer of a given set, based on what he/she deems most 
effective, given that sometimes only one flavour need be evaluated, and 
about equally often all flavours are needed at the same <i>x</i> and 
<i>Q^2</i>. Anyway, the latest value is always kept in memory. This is 
the other reason why <code>Pythia</code> has one separate <code>PDF</code> 
object for each beam, so that values at different <i>x</i> can be kept 
in memory. 

<p/>
Two further public methods are <code>xfVal( id, x, Q2)</code> and 
<code>xfSea( id, x, Q2)</code>. These are simple variants whereby
the quark distributions can be subdivided into a valence and a sea part.
If these are not directly accessible in the parametrization, onc can
make the simplified choices <i>u_sea = ubar_sea, u_val = u_tot - u_sea</i>,
and correspondingly for <i>d</i>. (Positivity will always be guaranteed
at output.) The <code>xfUpdate</code> method should also take care of
updating this information.

<p/>
A method <code>setExtrapolate(bool)</code> allows you to switch between
freezing parametrizations  at the <i>x</i> and <i>Q^2</i> boundaries 
(<code>false</code>) or extrapolating them outside the boundaries
(<code>true</code>). This method is only implemented for the LHAPDF class 
below. If you implement a new PDF you are free to use this method, but it 
would be smarter to hardcode the desired limiting behaviour. 

<h3>Derived classes</h3>

There is only one pure virtual method, <code>xfUpdate</code>, that 
therefore must be implemented in any derived class. A reasonable 
number of such classes come with the program:

<p/>
For protons:
<ul>
<li><code>LHAPDFinterface</code> provides an interface to the 
LHAPDF library[<a href="Bibliography.php" target="page">Wha05</a>].</li>
<li><code>GRV94L</code> gives the GRV 94 L parametrization 
[<a href="Bibliography.php" target="page">Glu95</a>].</li>
<li><code>CTEQ5L</code> gives the CTEQ 5 L parametrization 
[<a href="Bibliography.php" target="page">Lai00</a>].</li>
<li><code>MSTWpdf</code> gives the four distributions of the
MRST/MSTW group that have been implemented.</li>
<li><code>CTEQ6pdf</code> gives the six distributions of the
CTEQ/CT group that have been implemented.</li>
</ul>
The current default is CTEQ 5L, which has been used in most studies
to date.

<p/>
For charged pions:
<ul>
<li><code>GRVpiL</code> gives the GRV 1992 pi+ parametrization.</li>
</ul>

<p/>
For Pomerons (used to describe diffraction):
<ul>
<li><code>PomFix</code> gives a simple but flexible 
<i>Q2</i>-independent parametrization.</li>
<li><code>PomH1FitAB</code> gives the H1 2006 Fit A and Fit B
parametrizations.</li>
<li><code>PomH1Jets</code> gives the H1 2007 Jets parametrization.</li>
</ul>

<p/>
For charged leptons (e, mu, tau): 
<ul>
<li><code>Lepton</code> gives a QED parametrization [<a href="Bibliography.php" target="page">Kle89</a>].
In QED there are not so many ambiguities, so here one set should be 
enough. On the other hand, there is the problem that the 
lepton-inside-lepton pdf is integrably divergent for <i>x -> 1</i>, 
which gives numerical problems. Like in PYTHIA 6, the pdf is therefore
made to vanish for <i>x > 1 - 10^{-10}</i>, and scaled up in the range
<i>1 - 10^{-7} &lt; x &lt; 1 - 10^{-10}</i> in such a way that the 
total area under the pdf is preserved.</li>
<li><code>LeptonPoint</code> gives the trivial distribution of a
pointlike (i.e. unresolved) charged lepton.</li>
</ul>   

<p/>
For neutrinos:
<ul>
<li><code>NeutrinoPoint</code> is the only method, so there is no choice. 
Analogously to <code>LeptonPoint</code> it gives the distribution of a 
pointlike (i.e. unresolved) neutrino. A difference, however, is that 
neutrinos always are lefthanded, so there is no need to average over 
incoming spin states. Since the PYTHIA formalism assumes unpolarized 
beams, and thus implicitly includes a 1/2 for incoming fermions, the 
<code>NeutrinoPoint</code> PDF is normalized to 2 rather than 1 
to compensate for this.</li>
</ul>   

<p/>
There is another method, <code>isSetup()</code>, that returns the 
base-class boolean variable <code>isSet</code>. This variable is 
initially <code>true</code>, but could be set <code>false</code> if the 
setup procedure of a PDF failed, e.g. if the user has chosen an unknown 
PDF set.  

<p/> 
The MRST/MSTW, CTEQ/CT and H1 PDF routines are based on the interpolation
in <i>(x, Q)</i> grids. The grid files are stored in the 
<code>xmldoc</code> subdirectory, like settings and particle data.
Only PDF sets that will be used are read in during the initialization 
stage.

</body>
</html>

<!-- Copyright (C) 2012 Torbjorn Sjostrand -->
