
class RilException(Exception):
    def __init__(self,code,msg = ''):
        self.code = code
        Exception.__init__(self,g_codeMap[code] + msg)
        
MISSING_ACTION_ATTRIBUTE = 1
UNKNOWN_ACTION_ATTRIBUTE = 2
UNKNOWN_DEFINITION = 3
EXTENSION_ASSERT_REQUIRED = 4
UNKNOWN_ARGUMENT_TYPE = 5
UNKNOWN_ACTION = 6
INVALID_PREDICATE = 7
PARAM_ACTION_ALLOWS_ONE_CHILD = 8

g_codeMap = {
    MISSING_ACTION_ATTRIBUTE:"Missing required action attribute",
    UNKNOWN_ACTION_ATTRIBUTE:"Unknown action attribute: ",
    UNKNOWN_DEFINITION:"Unknown definition: ",
    EXTENSION_ASSERT_REQUIRED:"Extension Assert Required: ",
    UNKNOWN_ARGUMENT_TYPE:"Unknown Argument: ",
    UNKNOWN_ACTION:"Unknown Action: ",
    INVALID_PREDICATE:"Invalid Predicate: ",
    PARAM_ACTION_ALLOWS_ONE_CHILD:"Parameter tags allow only on child"
    }
