<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xml="http://www.w3.org/XML/1998/namespace"
  version="1.0"
>
  <xsl:output method='text' omit-xml-declaration='yes' indent='no'/>
  <xsl:template match="SMTP">
    <xsl:if test='ATTACHMENT'>
      <xsl:text>Content-Type: multipart/text/html;
          boundary="127.0.0.1.500.12859.945235597.150.29161"&#10;</xsl:text>
     </xsl:if>

    <xsl:apply-templates select='HEADER'/>
    <xsl:text>&#10;&#13;</xsl:text>
    <xsl:apply-templates select='BODY'/>
    <xsl:apply-templates select='ATTACHMENT'/>
  </xsl:template>

  <xsl:template match="HEADER">
     <xsl:value-of select='@name'/><xsl:text>: </xsl:text><xsl:apply-templates/><xsl:text>&#10;</xsl:text>
  </xsl:template>

  <xsl:template match="ATTACHMENT">
    <xsl:text>&#10;--127.0.0.1.500.12859.945235597.150.29161&#10;Content-Type: </xsl:text><xsl:value-of select='@type'/><xsl:text>&#10;&#10;&#13;</xsl:text>

	<xsl:apply-templates/>
	&#10;
  </xsl:template>

  <xsl:template match='*'>
    <xsl:copy-of select='.'/>
  </xsl:template>

</xsl:stylesheet>