import os, string, cStringIO
from Ft.Lib import pDomlette
from xml.dom import ext

def Test(tester):
    path = os.path.abspath(__file__)[len(os.getcwd())+1:]

    refUri = string.replace(path, os.sep, '/')
    tester.startGroup("Reader + XInclude")

    reader = pDomlette.PyExpatReader()
    
    tester.startTest("Entity Include")
    doc = reader.fromString(SRC_1, refUri)
    stream = cStringIO.StringIO()
    ext.PrettyPrint(doc, stream)
    tester.compare(expected_1, stream.getvalue())
    tester.testDone()
    
    tester.startTest("Basic Include")
    doc = reader.fromString(SRC_2, refUri)
    stream = cStringIO.StringIO()
    ext.PrettyPrint(doc, stream)
    tester.compare(expected_2, stream.getvalue())
    tester.testDone()

    tester.startTest("Recursive Include")
    doc = reader.fromString(SRC_3, refUri)
    stream = cStringIO.StringIO()
    ext.PrettyPrint(doc, stream)
    tester.compare(expected_3, stream.getvalue())
    tester.testDone()

    tester.startTest("XInclude text attribute")
    doc = reader.fromString(SRC_4, refUri)
    stream = cStringIO.StringIO()
    ext.PrettyPrint(doc, stream)
    tester.compare(expected_4, stream.getvalue())
    tester.testDone()

    tester.groupDone()

SRC_1 = """\
<?xml version='1.0'?>
<!DOCTYPE x [ <!ENTITY inc SYSTEM "include1.xml"> ]>
<x>
&inc;
</x>"""

SRC_2 = """\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include1.xml"/>
</x>"""

SRC_3="""\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml"/>
</x>"""

SRC_4="""\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml" parse='text'/>
</x>"""


expected_1="""<?xml version='1.0' encoding='UTF-8'?>
<x>
  <foo/>
</x>
"""

expected_2 = """<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
  <foo/>
</x>
"""

expected_3="""<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
  <foo>
    <foo/>
  </foo>
</x>
"""

expected_4="""<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
&lt;?xml version='1.0' encoding='utf-8'?>
&lt;foo xmlns:xi="http://www.w3.org/2001/XInclude">
  &lt;xi:include href="include1.xml"/>
&lt;/foo>
</x>
"""
