from xml.xpath import ParsedExpr
from xml.utils import boolean

class DummyBooleanExpr:
    def __init__(self,val):
        self.val = boolean.BooleanValue(val)

    def evaluate(self,context):
        return self.val

    def __repr__(self):
        return str(self.val)

class DummyNumberExpr:
    def __init__(self,val):
        self.val = val

    def evaluate(self,context):
        return self.val

    def __repr__(self):
        return str(self.val)

class DummyNodeSetExpr:
    def __init__(self, val=None):
        self.val = val

    def evaluate(self,context):
        return self.val

    def select(self,context):
        return self.val

    def __repr__(self):
        return '<%d-item nodeset>' % len(self.val)

class DummyStringExpr:
    def __init__(self,val=None):
        self.val = val or 'DummyString'

    def evaluate(self,context):
        return self.val

    def __repr__(self):
        return repr(self.val)


boolT = DummyBooleanExpr(1)
boolF = DummyBooleanExpr(0)
    
num1 = DummyNumberExpr(1)
num3 = DummyNumberExpr(3)
numN4 = DummyNumberExpr(-4)
num4p5 = DummyNumberExpr(4.5)

strPi = DummyStringExpr('3.14')
strText = DummyStringExpr('Hi')
strPiText = DummyStringExpr('3.14Hi')
strSpace = DummyStringExpr('Ht    \t There\t   Mike')
