#Example from David Carlisle to John Lam on 25 Feb 2000, with well-formedness and XSLT semantics corrections

from Xslt import test_harness

sheet_1 = """<total
  xsl:version="1.0"
  xsl:exclude-result-prefixes="ft"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ft="http://xmlns.4suite.org/ext"
  >

<xsl:variable name="x">
  <xsl:for-each select="x/thing">
    <a><xsl:value-of select="quantity * price"/></a>
  </xsl:for-each>
</xsl:variable>

<xsl:value-of select="sum(ft:node-set($x))"/>

</total>
"""


source_1="""<x>
<thing><quantity> 1</quantity><price> 2</price></thing>
<thing><quantity> 4</quantity><price> 5</price></thing>
<thing><quantity> 3</quantity><price>10</price></thing>
<thing><quantity> 2</quantity><price> 1</price></thing>
</x>
"""


expected_1="""<?xml version='1.0' encoding='UTF-8'?>
<total>54</total>"""


def Test(tester):

    tester.startGroup("Borrowed: dc_20000225")

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()

    return