from Xslt import test_harness

sheet_1 = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  >

  <xsl:import href="Xslt/Core/apply-imports-test.xslt"/>

  <xsl:template match="example">
    <div style="border: solid red">
      <xsl:apply-imports/>
    </div>
  </xsl:template>

</xsl:stylesheet>
"""

source_1 = "<example>This is an example</example>"

expected_1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<div style="border: solid red"><pre>This is an example</pre></div>"""


def Test(tester):

    tester.startGroup('apply-imports')
    source = test_harness.FileInfo(string=source_1,
                                   nsAware = 0)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()
