


def SetClassData(klass):

    #First create all of the tuple defs
    td = _MergeDictionaries(klass,'_tupleDefinitions')
    setattr(klass,'_tupleDefinitions',td)
    tn = _MergeTuples(klass,'_tupleNames')
    setattr(klass,'_tupleNames',tn)

    from Ft.Ods.PersistentObject import TupleDefinitions

    #Create the tuple types attrs
    tt = map(lambda x, td=td,tt=TupleDefinitions.TYPE:(td[x[0]][tt],),tn)
    klass._tupleTypes = tt

    #Create the _extents
    ext = _MergeTuples(klass,'_localExtents')
    setattr(klass,'_extents',ext)

    return

def _MergeDictionaries(klass,name):
    newDict = klass.__dict__.has_key(name) and getattr(klass,name) or {}
    for b in klass.__bases__:
        newDict.update(_MergeDictionaries(b,name))
    return newDict

def _MergeTuples(klass,name):
    newTuple = ()
    for b in klass.__bases__:
        newTuple = newTuple + _MergeTuples(b,name)

    if klass.__dict__.has_key(name):
        newTuple = newTuple + getattr(klass,name)
    return newTuple


g_moduleNames = ['Repository',
                 'Module',
                 'PrimitiveType',
                 'Dictionary',
                 'Collection',
                 'Literal',
                 'ConstOperand',
                 'Operation',
                 'Expression',

                 'Member',
                 'UnionCase',

                 'Union',
                 'Constant',

                 'TypeDefinition',
                 'Enumeration',
                 'Structure',
                 'Exception',

                 'Class',
                 'Interface',

                 'Attribute',
                 'Relationship',
                 'Parameter',
                 ]

g_klasses = []

for module in g_moduleNames:
    m = __import__('Ft.Ods.MetaData.'+module,{},{},module)
    klass = getattr(m,module)
    g_klasses.append(klass)
    SetClassData(klass)


