########################################################################
#
# File Name:            Dbm.py
#
# Documentation:        http://docs.4suite.org/4Rdf/Drivers/Dbm.py.html
#
"""
A simple persistent back end
WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 1999,2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import os, cPickle, threading
from Ft.Rdf.Drivers import Memory
from Ft.Rdf.Drivers import PROPERTIES

from Ft import LOCALSTATEDIR
DATABASE_DIR = os.path.join(LOCALSTATEDIR,'lib', 'ftss', 'Databases')
DATABASE_DIR = os.environ.get('FT_DATABASE_DIR', DATABASE_DIR)

# Normalize path, remove unnecessary slashes
DATABASE_DIR = os.path.abspath(DATABASE_DIR)

def CreateFileName(dbName):
    if dbName[:4] != 'rdf:':
        return os.path.join(DATABASE_DIR,'ftrdf__%s' % dbName)
    return dbName[4:]

# Management functions
def ExistsDb(dbName,modelName='default'):
    fName = CreateFileName(dbName)
    if os.path.exists(fName):
        try:
            fd = open(fName)
            d = cPickle.load(fd)
            fd.close()
            return d.has_key('ftrdf_%s_statements' % modelName) and d.has_key('ftrdf_%s_bound'%modelName)
        except:
            return 0
    return 0
        

def CreateDb(dbName,modelName='default'):
    fName = CreateFileName(dbName)
    if os.path.exists(fName):
        os.unlink(fName)
    d = {}
    d['ftrdf_%s_statements'%modelName] = []
    d['ftrdf_%s_bound'%modelName] = {}
    fd = open(fName,'wb')
    cPickle.dump(d,fd)
    fd.close()
    return GetDb(dbName)

def GetDb(dbName,modelName='default'):
    return DbAdapter(dbName, modelName)

def DestroyDb(dbName,modelName='default'):
    fName = CreateFileName(dbName)
    if os.path.exists(fName):
        os.unlink(fName)

# The RDF Adapter interface
class DbAdapter(Memory.DbAdapter):
    def __init__(self, name,modelName='default'):
        self._name = 'ft__%s' % name
        self._fName = CreateFileName(name)
        self._changed = 0
        self._modelName = modelName
        self.props = {PROPERTIES.OBJECT_TYPE_SUPPORTED: 1}
        return

    def begin(self):
        self._statements, self._bound = g_modelCache.begin(self._fName, self._modelName)
        self._db = 1
        return

    def commit(self):
        if self._changed:
            g_modelCache.commit(self._fName, self._statements, self._bound,
                                self._modelName)
        self._db = 0
        return

    def rollback(self):
        self._db = 0
        return


    def add(self, statements):
        self._changed = 1
        return Memory.DbAdapter.add(self, statements)


    def remove(self, statements):
        self._changed = 1
        return Memory.DbAdapter.remove(self, statements)

    def removePattern(self, subject, predicate, object, statementUri,
                      scope, flags):
        self._changed = 1
        return Memory.DbAdapter.removePattern(self, subject, predicate,
                                              object, statementUri, scope,
                                              flags)

    def bind(self, object, name, scope):
        self._changed = 1
        return Memory.DbAdapter.bind(self, object, name, scope)

    def unbind(self, name, scope):
        self._changed = 1
        return Memory.DbAdapter.unbind(self,name, scope)


class ModelCache:

    def __init__(self):
        self._locks = {}
        
    def begin(self, fName, modelName):

        if not self._locks.has_key(fName):
            self._locks[fName] = threading.RLock()

        self._locks[fName].acquire()
        try:
            fd = open(fName,'rb')
            db = cPickle.load(fd)
            fd.close()
            stmts = {modelName:db['ftrdf_%s_statements'%modelName]}
            return (stmts,db['ftrdf_%s_bound' % modelName])
        finally:
            self._locks[fName].release()


    def commit(self, fName, statements, bound, modelName):

        if not self._locks.has_key(fName):
            self._locks[fName] = threading.RLock()

        self._locks[fName].acquire()
        try:
            d = {'ftrdf_%s_statements'%modelName:statements[modelName],
                 'ftrdf_%s_bound'%modelName:bound}
            fd = open(fName,'wb')
            cPickle.dump(d,fd)
            fd.close()
        finally:
            self._locks[fName].release()


g_modelCache = ModelCache()

