########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/RawFile.py,v 1.10 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch rawfile' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command prints the raw content of a resource in a \
4Suite repository, without additional interpretation. The resource \
type must be a Raw File or a subclass thereof (most resource types \
are). If necessary, you will be prompted first for credentials and \
access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil


def Run(options,args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.rawfile')
    if repo is not None:
        try:
            doc = repo.fetchResource(args['path'])
            CommandUtil.WritePreamble("Raw File %s (%s):" % (doc.getPath(), doc.getImt()))
            content = doc.getContent()
            sys.stdout.write(content)
            sys.stdout.flush()
            if content[-1] != '\n':
                sys.stderr.write('\n')
                sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('rawfile',
                          'Print raw content of a resource in a repository',
                          '/ftss/data/4SSPowered.jpg > localfile.jpg',
                          __doc__,
                          function=Run,
                          arguments = [Arguments.RequiredArgument('path',
                                                                  'the path of the Raw File',
                                                                  str),
                                       ],
                          fileName=__file__,
                          )
    return cmd
