########################################################################
#
# File Name:            DocumentDefinition.py
#
# Documentation:        http://docs.4suite.org/4SS/DocumentDefinition.py.html
#
"""
4Suite server document definitions: contain system and user metadata for managed documents
WWW: http://4suite.org         e-mail: support@4suite.org

Copyright (c) 2001 Fourthought, Inc. USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
import XmlDocumentClient

from Ft.Server.FtRpc import Commands

class DocumentDefinitionClient(XmlDocumentClient.XmlDocumentClient):


    def addBaseDocumentDefinition(self,baseDef):
        """
        Add a base document definition to this document definition.  This will cause all of the documents
        associated with this document definition to be re-processed and could take a long time
        """
        return Commands.RemoteMethodCommand('addBaseDocumentDefinition',
                                            self._path,
                                            ((None,baseDef.getAbsolutePath()),)
                                            ).send(self._connection).results


    def getBaseDefinitions(self):
        """
        Get the base definitions of this document definition
        """
        paths = Commands.RemoteMethodCommand('getBaseDefinitions',
                                             self._path,
                                             ()
                                             ).send(self._connection).results
        bd = []
        for p in paths:
            bd.append(self.fetchResource(p))
        return bd
        
    def getCreationParams(self):
        """
        Get the creation parameters associated with this document definition.  See Ft.Server.Core.CreationParamsImp.py
        """
        return Commands.RemoteMethodCommand('getCreationParams',
                                            self._path,
                                            ()
                                            ).send(self._connection).results


    def getDerivedDefinitions(self):
        """
        Get all of the parent definitions of this document definition
        """
        paths = Commands.RemoteMethodCommand('getDerivedDefinitions',
                                             self._path,
                                             ()
                                             ).send(self._connection).results
        dd = []
        for p in paths:
            dd.append(self.fetchResource(p))
        return dd

    def getMetaDocumentUris(self,recurse=1):
        """
        Get a list of all documents that use this doc def
        """
        return Commands.RemoteMethodCommand('getMetaDocumentUris',
                                            self._path,
                                            (recurse,)
                                            ).send(self._connection).results


    def removeBaseDocumentDefinition(self,baseDef,recurse=1):
        """
        Remove a base document definition.  This will cause all of the documents
        associated with this document definition to be regenerated.
        """
        return Commands.RemoteMethodCommand('removeBaseDocumentDefinition',
                                            self._path,
                                            ((None,baseDef.getAbsolutePath()),recurse)
                                            ).send(self._connection).results

    def setCreationParams(self,newCp):
        """
        Set the creation parameters of this document definition
        """
        return Commands.RemoteMethodCommand('setCreationParams',
                                            self._path,
                                            (newCp,)
                                            ).send(self._connection).results

