<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://xmlns.4suite.org/">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  xmlns:xlink='http://www.w3.org/1999/xlink'
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <xsl:variable name="containerID" select="'http://schemas.4suite.org/4ss#container'"/>
  <xsl:variable name="commandID" select="'http://schemas.4suite.org/4ss#command'"/>
  <xsl:variable name="rawFileID" select="'http://schemas.4suite.org/4ss#rawfile'"/>
  <xsl:variable name="uriReferenceID" select="'http://schemas.4suite.org/4ss#urireferencefile'"/>
  <xsl:variable name="serverID" select="'http://schemas.4suite.org/4ss#server'"/>

  <xsl:template name="container-manager" match="fres:Container">
    <xsl:variable name="sortChildren">
      <xsl:choose>
        <xsl:when test="fhttp:get-query-args()//sortChildren">
          <xsl:value-of select="fhttp:get-query-args()//sortChildren"/>
        </xsl:when>
        <xsl:otherwise>type</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <table class="normal" cellpadding="4" cellspacing="1">
      <xsl:if test="not(fhttp:get-query-args()//metaContainer)">
        <tr>
          <td colspan="5">
            <span class="blackTitle">Adding Content</span>
          </td>
        </tr>
        <tr>
          <td colspan="5">To add a file, container or other resource to <xsl:value-of select="$resourcePath"/>, select it from the list and click Add.</td>
        </tr>
        <tr>
          <td colspan="5">
            <select name="newResourceType" class="drop-down" size="1">
              <option value="Xml">XML Document</option>
              <option value="Xslt">XSLT Document</option>
              <option value="Container">Container</option>
              <option value="DocDef">DocumentDefinition</option>
              <option value="RdfDoc">RDF Document</option>
              <option value="File">File</option>
              <option value="Urireference">Uri Reference</option>
              <option value="User">User</option>
              <option value="Group">Group</option>
            </select>
            <input type="hidden" name="action" value="containerAddOrRemove"/>
            <input type="submit" value="Add Resource" name="containerManagerSubmit" class="button"/>
          </td>
        </tr>
        <tr>
          <td colspan="7">
            <hr/>
          </td>
        </tr>
      </xsl:if>
      <xsl:copy-of select='/fres:Container/fres:Children/fres:ChildReference'/>
      <xsl:if test="/fres:Container/fres:Children/fres:ChildReference">
        <!--Load all of the MetaData-->
        <xsl:variable name='ch' f:node-set="yes">
          <fres:Children>
            <xsl:for-each select='/fres:Container/fres:Children/fres:ChildReference'>
              <!--<xsl:value-of select='f:resolve-path($fres:uri-path, @xlink:href)'/>-->
              <xsl:copy-of select='document(f:resolve-path($fres:uri-path, @xlink:href))/fres:MetaData'/>
            </xsl:for-each>
          </fres:Children>
        </xsl:variable>
        <xsl:variable name="children" select="$ch/fres:Children"/>
        <tr>
          <td colspan="5">
            <span class="blackTitle">Browsing Content</span>
          </td>
        </tr>
        <tr>
          <td colspan="5" nowrap="nowrap">Click on any child resource's name to manage it.<br/>Click on any of the category headers to sort the children by that criteria</td>
        </tr>
        <tr>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=name">Name</a>
          </th>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=date">Last Modified</a>
          </th>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=size">Size</a>
          </th>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=type">System Type</a>
          </th>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=imt">Internet Media Type</a>
          </th>
          <th class="grayBar">
            <a href="{@resourcePath}?sortChildren=owner">Resource Owner</a>
          </th>
          <th/>
        </tr>
        <!--f:dump-vars/-->
        <xsl:choose>
          <xsl:when test="$sortChildren = 'name'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData">
              <xsl:sort select="@path"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$sortChildren = 'date'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData">
              <xsl:sort select="fres:LastModifiedDate"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$sortChildren = 'size'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData"/>
          </xsl:when>
          <xsl:when test="$sortChildren = 'type'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData">
              <xsl:sort select="@type"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$sortChildren = 'imt'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData">
              <xsl:sort select="fres:Imt"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$sortChildren = 'owner'">
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData">
              <xsl:sort select="fres:Owner"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates mode="childEntry" select="$children/fres:MetaData"/>
          </xsl:otherwise>
        </xsl:choose>
        <tr>
          <td colspan="7">
            <hr/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="not(fhttp:get-query-args()//metaContainer)">
        <tr>
          <td colspan="7">
            <span class="blackTitle">Removing Content</span>
          </td>
        </tr>
        <tr>
          <td colspan="5">
            <input type="submit" value="Remove Resource(s)" class="button" name="containerManagerSubmit"/>
          </td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>

  <xsl:template match="fres:MetaData" mode="childEntry">
    <tr>
      <!-- NAME/LINK -->
      <td class="cellEntry">
        <xsl:apply-templates select="." mode="link"/>
      </td>
      <!-- LAST MODIFICATION DATE -->
      <td class="cellEntry" nowrap="nowrap">
        <xsl:variable name='lmd' select="fres:LastModifiedDate"/>
        <xsl:if test="normalize-space($lmd)">
          <xsl:value-of select='concat(exslt-date-time:month-abbreviation($lmd)," ",exslt-date-time:day-in-month($lmd)," ",format-number(exslt-date-time:hour-in-day($lmd),"00"),":",format-number(exslt-date-time:minute-in-hour($lmd),"00"))'/>
        </xsl:if>
      </td>
      <!-- Size -->
      <td class="cellEntry">
        <xsl:value-of select='format-number(fres:Size div 1000.0, "#,###.0k")'/>
      </td>
      <!-- RESOURCE TYPE -->
      <td class="cellEntry">
        <xsl:value-of select="substring-after(@type,'#')"/>
      </td>
      <!-- IMT -->
      <td class="cellEntry">
        <xsl:value-of select="fres:Imt"/>
      </td>
      <!-- Owner -->
      <td class="cellEntry">
        <xsl:value-of select="fres:Owner"/>
      </td>
      <!-- ACL -->
      <!--<td class='cellEntry'>Edit ACL</td>-->
      <!--Selection-->
      <xsl:if test="not(fhttp:get-query-args()//metaContainer)">
        <td class="cellEntry">
          <input type="checkbox" name="delete:{f:resolve-path(concat($resourcePath ,'/'),@path)}"/>
        </td>
      </xsl:if>
    </tr>
  </xsl:template>
  <xsl:template match="fres:MetaData" mode="link">
    <xsl:variable name="fullPath" select="f:resolve-path(concat($resourcePath ,'/'),@path)"/>
    <xsl:choose>
      <xsl:when test="@type = $uriReferenceID">
        <xsl:call-template name="ShowIcon">
          <xsl:with-param name="imgSrc" select="'/ftss/data/icons/link.gif'"/>
        </xsl:call-template>
        <xsl:text>&nbsp;</xsl:text>
        <a href="/?nonXMLPath={$fullPath}">
          <xsl:value-of select="@path"/>
        </a>
      </xsl:when>
      <xsl:when test="@type = $rawFileID">
        <xsl:choose>
          <xsl:when test="starts-with(fres:Imt,'image')">
            <xsl:call-template name="ShowIcon">
              <xsl:with-param name="imgSrc" select="'/ftss/data/icons/image1.gif'"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="ShowIcon">
              <xsl:with-param name="imgSrc" select="'/ftss/data/icons/binary.gif'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&nbsp;</xsl:text>
        <a href="/?nonXMLPath={$fullPath}">
          <xsl:value-of select="@path"/>
        </a>
      </xsl:when>
      <xsl:when test="@type = $serverID">
        <xsl:call-template name="ShowIcon">
          <xsl:with-param name="imgSrc" select="'/ftss/data/icons/comp.gray.gif'"/>
        </xsl:call-template>
        <xsl:text>&nbsp;</xsl:text>
        <xsl:choose>
          <xsl:when test="document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/DefaultManager = 'Basic'">
            <a href="{$fullPath}?basic=1">
              <xsl:value-of select="@path"/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <a href="{$fullPath}">
              <xsl:value-of select="@path"/>
            </a>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="@type = $containerID">
        <xsl:call-template name="ShowIcon">
          <xsl:with-param name="imgSrc" select="'/ftss/data/icons/folder.gif'"/>
        </xsl:call-template>
        <xsl:text>&nbsp;</xsl:text>
        <a href="{$fullPath}">
          <xsl:value-of select="@path"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
        <xsl:choose>
          <xsl:when test="document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/DefaultManager = 'Basic'">
            <a href="{$fullPath}?basic=1">
              <xsl:value-of select="@path"/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <a href="{$fullPath}">
              <xsl:value-of select="@path"/>
            </a>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="ShowIcon">
    <xsl:param name="imgSrc"/>
    <xsl:choose>
      <xsl:when test="document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/Icons = 'Yes'">
        <img src="{$imgSrc}"/>
      </xsl:when>
      <xsl:otherwise>&nbsp;&nbsp;&nbsp;</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
