########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/XsltDocumentDefinitionImp.py,v 1.8 2003/01/10 05:39:13 mbrown Exp $
"""
XsltDocumentDefinition repository resource class

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import DocumentDefinitionImp, XsltDocumentImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import ResourceTypes


class XsltDocumentDefinitionImp(DocumentDefinitionImp.DocumentDefinitionImp,
                                XsltDocumentImp.XsltDocumentImp):
    """
    An XSLT-based document definition document
    """
    resourceType = ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION

    def asStylesheet(self):
        return XsltDocumentImp.XsltDocumentImp.asStylesheet(self)

    def setContent(self,src):
        XsltDocumentImp.XsltDocumentImp.setContent(self,src)
        self._update()


def NewDocumentDefinitionXml(driver, path, acl, owner, imt, src, docDef):
    return DocumentDefinitionImp.NewDocumentDefinitionXml(
        driver, path, acl, owner, imt, src, docDef,
        ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION
        )


NEW_SHEET_XUPDATE="""<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:append select="/*" child="last()">
    <ftss:BaseNames/>
  </xupdate:append>
</xupdate:modifications>
""" % FTSERVER_NAMESPACE
