########################################################################
#
# File Name:            Groupableobject.py
#
"""
XSLT and XPath extensions supporting the 4SS groupableobject API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions


def GetGroups(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)
    groups = [ group.getAbsolutePath() for group in base.getGroups() ]

    doc = context.node.rootNode
    return map(doc.createTextNode, groups)


ExtFunctions = {
    (SCORE_NS, 'get-groups'): GetGroups,    
}

ExtElements = {
#    (NS, 'repo-text-reindex'): TextReindexRepositoryElement,
}
