########################################################################
#
# File Name:            UriReferenceFile.py
#
"""
XSLT and XPath extensions supporting the 4SS UriFileReference API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions

from Ft.Xml.Xslt import XsltElement
from Ft.Xml.Xslt import ContentInfo, AttributeInfo
from Ft.Xml.Xslt import OutputParameters
import cStringIO


def GetReference(context,path=None):
    """
    Get the URI that this resource references
    """
    path = Conversions.StringValue(path)
    #print path
    return FtssXsltBase.FetchBaseObject(context.processor,path).getReference()

class SetReferenceElement(XsltElement):
    """
    Change what a URI reference references.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document'),
        'reference' : AttributeInfo.UriReferenceAvt(required=1,
						    description='The new URI'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
        ref = self._reference.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)
	print base, path, ref
	base.setReference(ref)

        return (context,)

ExtFunctions = {
    (SCORE_NS, 'get-reference'): GetReference,    
}

ExtElements = {
    (SCORE_NS, 'set-reference'): SetReferenceElement,    
}
