<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  xmlns:xlink='http://www.w3.org/1999/xlink'
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  container.xslt

Description:

    Default view for a container

WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->

  <xsl:output method='html' doctype-public='-//W3C//DTD HTML 3.2 Final//EN'/>

  <xsl:param name='fres:uri-path'/>
  <xsl:param name='fres:absolute-path'/>
  <xsl:param name='fres:base-path'/>

  <xsl:variable name='nodes' select='/descendant-or-self::node()'/>

  <xsl:template match='/'>
    <html>
      <head>
        <title>Listing of <xsl:value-of select='$fres:uri-path'/></title>
      </head>
      <body>
        <h1>Listing of <xsl:value-of select='$fres:uri-path'/></h1>
        <hr/>
        <xsl:apply-templates select='fres:Container/fres:Children'/>
        <hr/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match='fres:ChildReference'>
    <xsl:apply-templates select='document(f:resolve-path($fres:base-path,@xlink:href))/fres:MetaData'>
      <xsl:sort select='@path'/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match='fres:Children'>
    <xsl:if test='$fres:uri-path != "/"'>
      <pre><a href='{fhttp:local-path(fcore:get-parent($fres:absolute-path))}/'>Up to a higher level container</a></pre>
    </xsl:if>
    <table cellpadding="0" cellspacing="0" border="0">
      <tr>
        <th align='left'>
          <xsl:variable name='header' select='"Name"'/>
          <samp>
            <xsl:value-of select='$header'/>
            <xsl:for-each select='$nodes[position() &lt; (32 - string-length($header))]'>
              <xsl:text>&#160;</xsl:text>
            </xsl:for-each>
          </samp>
        </th>
        <th align='left'>
          <xsl:variable name='header' select='"Last Modified"'/>
          <samp>
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select='$header'/>
            <xsl:for-each select='$nodes[position() &lt; (24 - string-length($header))]'>
              <xsl:text>&#160;</xsl:text>
            </xsl:for-each>
          </samp>
        </th>
        <th align='right'>
          <samp>&#160;&#160;&#160;&#160;Size</samp>
        </th>
        <th align='left'>
          <samp>&#160;&#160;Media Type</samp>
        </th>
      </tr>
      <xsl:apply-templates select='*'>
        <xsl:sort select='@path'/>
      </xsl:apply-templates>
    </table>
  </xsl:template>

  <xsl:template match='fres:MetaData'>
    <xsl:variable name='display'>
      <xsl:value-of select="@path"/>
      <xsl:if test="contains(@type,'#container')">/</xsl:if>
    </xsl:variable>
    <tr>
      <td>
        <samp>
          <a href="{$display}"><xsl:value-of select="$display"/></a>
        </samp>
      </td>
      <td>
        <xsl:variable name='now' select='fres:LastModifiedDate'/>
        <xsl:variable name='time' select='concat(substring-before(exslt-date-time:time($now),"-")," ",format-number(exslt-date-time:day-in-month($now),"00"),"-",exslt-date-time:month-abbreviation($now),"-",exslt-date-time:year($now))'/>
        <samp><xsl:value-of select='concat("&#160;",$time)'/></samp>
      </td>
      <td align='right'>
        <samp>
          <xsl:choose>
            <xsl:when test="fres:Size &lt; 1048576">
              <xsl:value-of select='format-number(fres:Size div 1024.0, "#,##0.0K")'/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select='format-number(fres:Size div 1048576.0, "#,##0.0M")'/>
            </xsl:otherwise>
          </xsl:choose>
        </samp>
      </td>
      <td>
        <samp>&#160;&#160;<xsl:value-of select='fres:Imt'/></samp>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
