<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY bbs "http://uche.ogbuji.net/example/buyerbase/soap">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:bbs="&bbs;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  customer-report.xslt

Description:

    This stylesheet is not currently used in the Buyer Base demo.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <xsl:template match="bbs:getCustomerPurchaseTotal">
    <xsl:variable name="purchase-files" f:node-set="yes">
      <frdf:versa-query query="('{id}' &lt;- bbschema:id -*) - bbschema:order -> *"/>
    </xsl:variable>
    <env:Envelope
      xmlns:env="http://www.w3.org/2001/12/soap-envelope"
      env:encodingStyle="http://www.w3.org/2001/12/soap-encoding"
      xmlns:bbs="http://uche.ogbuji.net/example/buyerbase/soap"
    >
      <env:Body>
        <bbs:getCustomerPurchaseTotalResponse>
        <value>
          <xsl:call-template name="tot-up">
            <xsl:with-param name="total"/>
            <xsl:with-param name="purchase-files" select="$purchase-files/List/*"/>
          </xsl:call-template>
        </value>
      </bbs:getCustomerPurchaseTotalResponse>
      </env:Body>
    </env:Envelope>
  </xsl:template>

  <xsl:template name="tot-up">
    <xsl:param name="total" select="0"/>
    <xsl:param name="purchase-files"/>
    <xsl:param name="pinfo" select="document($purchase-files[1])/bb:purchase/bb:item[1]"/>
    <xsl:param name="new-total" select="$total + $pinfo/bb:quantity * $pinfo/bb:unitprice"/>
    <xsl:choose>
      <xsl:when test="$purchase-files[position()>1]">
        <xsl:call-template name="tot-up">
          <xsl:with-param name="total" select="$new-total"/>
          <xsl:with-param name="purchase-files" select="$purchase-files[position()>1]"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="format-number($new-total, '#,##0.00')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>

