<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  customer.xslt

Description:

    This stylesheet generates the form through which a customer can be
    added or edited. If editing an existing customer, the stylesheet
    must be applied to a customer XML document. If adding a new
    customer, it must be applied to any other kind of XML document.
    In either case, the form data is processed by submit-customer.xslt.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <xsl:variable name="id" select="bb:customer/@id"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="not(fcore:has-session())">
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="menus">
          <xsl:with-param name="pageTitle" select="'Buyer Base - Customer Profile'"/>
          <xsl:with-param name="include-javascript" select="true()"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="body">
    <xsl:variable name="fileName" select="fhttp:local-path(frdf:complete(frdf:any(),'&bbschema;id', $id)/Subject)"/>
    <table width="695">
      <tr>
        <td>
          <p class="blackTitle">
          <a href="/buyerbase/?xslt=index.xslt">
              <font color="#000000">View Customer Index</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <xsl:choose>
              <xsl:when test='fcore:has-session()'>
                <xsl:choose>
                  <xsl:when test='$id'>
                    <a href="{$fileName}?xslt=../purchase-summary.xslt">
                      <font color="#000000">View Purchase Summary</font>
                    </a>
                    <xsl:text>&nbsp;|&nbsp;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <a href="{$fres:uri-path}?xslt=../customer.xslt">
                      <font color="#000000">Add New Customer</font>
                    </a>
                    <xsl:text>&nbsp;|&nbsp;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
                <a href="/buyerbase/?xslt=logout.xslt">
                  <font color="#000000">Logout</font>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <a href="/buyerbase/?xslt=home.xslt">
                  <font color="#000000">Login</font>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          </p>

          <xsl:variable name='sty'>
            <xsl:choose>
              <xsl:when test='$id'>../submit-customer.xslt</xsl:when>
              <xsl:otherwise>submit-customer.xslt</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:choose>
            <xsl:when test='fcore:has-session()'>
              <form name="main" method="post" action="{$fres:uri-path}?xslt={$sty}">
                <input type="hidden" id="actionToDo" name="actionToDo" value="xupdate"/>
                <input type="hidden" name="id" value="{$id}"/>
                <table valign="top" width="700" align="left" class="normal">
                  <tr class="cellBlue">
                    <td colspan="2" align="left" class="menucell"><div class="menu">Customer Profile</div></td>
                  </tr>
                  <xsl:choose>
                    <xsl:when test='$id'>
                      <xsl:apply-templates select="bb:customer">
                        <xsl:with-param name='edit' select='1'/>
                      </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:call-template name='display-customer'>
                        <xsl:with-param name='edit' select='1'/>
                      </xsl:call-template>
                    </xsl:otherwise>
                  </xsl:choose>
                  <tr>
                    <td colspan="2">
                      <xsl:choose>
                        <xsl:when test="$id">
                          <input name="updateBtn" onclick="document.main.actionToDo.value = 'xupdate'" class="button" type="submit" tabindex="12" value="Update Record"/>&nbsp;&nbsp;
                          <input name="deleteBtn" onclick="javascript: confirmRecordDelete('customer')" class="button" type="button" tabindex="13" value="Delete Record"/>&nbsp;&nbsp;
                        </xsl:when>
                        <xsl:otherwise>
                          <input name="createBtn" onclick="document.main.actionToDo.value = 'create'" class="button" type="submit" tabindex="11" value="Create Record"/>&nbsp;&nbsp;
                        </xsl:otherwise>
                      </xsl:choose>
                      <input name="cancel" class="button" type="reset" tabindex="14" value="Cancel"/>
                    </td>
                  </tr>
                </table>
              </form>
            </xsl:when>
            <xsl:otherwise>
              <table valign="top" width="700" align="left" class="normal">
                <tr class="cellBlue">
                  <td colspan="2" align="left" class="menucell"><div class="menu">Customer</div></td>
                </tr>
                <xsl:apply-templates select="bb:customer">
                  <xsl:with-param name='edit' select='0'/>
                </xsl:apply-templates>
              </table>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="bb:customer" name='display-customer'>
    <xsl:param name='edit'/>
     <tr>
      <td width="150">Name:</td>
      <td width="545">
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="fullname" value="{bb:fullname}" size="40" class="textBox" tabindex="1"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:fullname'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Title:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="profession" value="{bb:profession}" size="40" class="textBox" tabindex="2"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:profession'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Work Phone:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="workPhone" value="{bb:phone[@desc='work']}" size="25" class="textBox" tabindex="3"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:phone[@desc="work"]'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Home Phone:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="homePhone" value="{bb:phone[@desc='home']}" size="25" class="textBox" type="text" tabindex="4"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:phone[@desc="home"]'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Email:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="email" value="{bb:email}" size="35" class="textBox" type="text" tabindex="5"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:email'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr class="cellBlue">
      <td colspan="2" align="left" class="menucell"><div class="menu">Company</div></td>
    </tr>
    <tr>
      <td>Company:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="employer" value="{bb:employer}" size="40" class="textBox" type="text" tabindex="6"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:employer'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Street:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="address" size="35" value="{bb:address/text()}" class="textBox" tabindex="7"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:address/text()'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>City:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="city" size="25" value="{bb:address/bb:city}" class="textBox" tabindex="8"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:address/bb:city'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>State:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="state" size="15" value="{bb:address/bb:state}" class="textBox" tabindex="9"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:address/bb:state'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>Zip Code:</td>
      <td>
        <xsl:choose>
          <xsl:when test='$edit'>
            <input name="zip" size="15" value="{bb:address/bb:zip}" class="textBox" tabindex="10"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='bb:address/bb:zip'/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
