<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY daml "http://www.daml.org/2001/03/daml+oil#">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">

]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:rdf="&rdf;"
  xmlns:rdfs="&rdfs;"
  xmlns:daml="&daml;"
  xmlns:fres="http://xmlns.4suite.org/reserved"
  xmlns:dc="&dc;"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns:f="http://xmlns.4suite.org/ext"
  xmlns:g="http://xmlns.4suite.org/demo/genitive"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-functions">
  <!--
File:  index.xslt

A plain rendering of the current node

WWW: http://4suite.org        e-mail: support@4suite.org

Copyright 2004 Fourthought Inc, USA
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->
  <!-- include the template for the navigation bars -->

  <xsl:import href="framework.xslt"/>
  <xsl:import href="common.xslt"/>
  <xsl:import href="demo-components.xslt"/>

  <xsl:output method="html"/>

  <xsl:param name="props"/>
  <xsl:variable name="props-doc" f:node-set="yes" select="document($props)"/>

  <xsl:variable name="props-set" f:node-set="yes">
    <forward-property id="&rdf;type">type</forward-property>
    <forward-property id="&rdf;value">value</forward-property>
    <!--forward-property id="&rdfs;label">label</forward-property-->
    <forward-property id="&rdfs;description">description</forward-property>
    <forward-property id="&rdfs;subClassOf">base class</forward-property>
    <forward-property id="&rdfs;subPropertyOf">sub-forward-property of</forward-property>
    <forward-property id="&rdfs;domain">domain</forward-property>
    <forward-property id="&rdfs;range">range</forward-property>
    <reverse-property id="&rdf;type">Instances</reverse-property>
    <reverse-property id="&rdfs;subClassOf">Sub-classes</reverse-property>
    <xsl:if test="$props">
      <xsl:copy-of select="$props-doc/properties/*"/>
    </xsl:if>
  </xsl:variable>

  <xsl:param name="style" select="'genitive'"/>

  <xsl:param name="start" select="$props-doc/properties/@start"/>

  <xsl:variable name="source" f:node-set="yes">
    <xsl:choose>
      <xsl:when test="$start">
        <xsl:variable name="start-label" select="g:resource-label($start)"/>
        <!--
             <xsl:message><f:dump-vars/></xsl:message>
        -->

        <page template="genitive.xhtml">
          <head>
            <title>Genitive - Plain view of <xsl:value-of select="$start-label"/>
            </title>
            <stylesheet type="minimal">
              <xsl:value-of select="$style"/>-ns.css</stylesheet>
            <stylesheet type="ie">
              <xsl:value-of select="$style"/>-ie.css</stylesheet>
          </head>
          <content>
            <data-dict>
              <title>
                <xsl:value-of select="$start-label"/>
              </title>
              <section name="properties">
                <title>Properties</title>
                <element-list type="dict">
                  <!-- Forward properties -->
                  <xsl:apply-templates select="$props-set/forward-property"/>
                </element-list>
              </section>
              <!-- Reverse properties -->
              <xsl:apply-templates select="$props-set/reverse-property"/>
            </data-dict>
          </content>
        </page>
      </xsl:when>
      <xsl:otherwise>
        <h1>No start resource specified.  Using default</h1>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:template match="forward-property">

    <xsl:variable name="label" select="."/>
    <xsl:variable name="value-result" f:node-set="yes">
      <frdf:versa-query query="@'{$start}' - @'{./@id}' -> *"/>
    </xsl:variable>

    <xsl:if test="$value-result/List/*">
      <xsl:for-each select="$value-result/List/*">
        <xsl:variable name="value-label" select="g:resource-label(.)"/>

        <element type="dict-item">
          <label>
            <xsl:value-of select="$label"/>
          </label>
          <value>
            <xsl:value-of select="$value-label"/>
          </value>

          <xsl:if test="substring($value-result, 1, 4) = 'urn:' or substring($value-result, 1, 5) = 'http:'">
            <link>
              <xsl:value-of select="concat('?xslt=/ftss/demos/Genitive/plain.xslt&amp;start=', exslt-str:encode-uri(., false()), '&amp;props=' , $props, '&amp;style=', $style)"/>
            </link>
          </xsl:if>
        </element>
        </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <xsl:template match="List" mode="element">
    <xsl:param name="label"/>
  </xsl:template>


  <xsl:template match="reverse-property">
    <xsl:variable name="resource-result" f:node-set="yes">
      <frdf:versa-query query="@'{$start}' &lt;- @'{./@id}' - *"/>
    </xsl:variable>

    <xsl:if test="$resource-result/List/*">
      <section name="{.}" type="ul">
        <title>
          <xsl:value-of select="."/>
        </title>
        <element-list type="ul">

          <xsl:for-each select="$resource-result/List/*">
            <xsl:variable name="resource-label" select="g:resource-label(.)"/>
            <element type="list-item">
              <label>
                <xsl:value-of select="."/>
              </label>
              <value>
                <xsl:value-of select="$resource-label"/>
              </value>

              <xsl:if test="substring($resource-result, 1, 4) = 'urn:' or substring($resource-result, 1, 5) = 'http:'">
                <link>
                  <xsl:value-of select="concat('?xslt=/ftss/demos/Genitive/plain.xslt&amp;start=', exslt-str:encode-uri(., false()),'&amp;props=', $props,   '&amp;style=', $style)"/>
                </link>
              </xsl:if>
            </element>
          </xsl:for-each>
        </element-list>
      </section>
    </xsl:if>
  </xsl:template>

  <xsl:template match="f:component[@type='content' and @data-group='data-dict']">
    <tr valign="middle" align="center" height="40">
      <td width="695" class="logo" colspan="2">
          <!--xsl:copy-of select="$source"/-->          <xsl:value-of select="$source/page/content/data-dict/title"/>
      </td>
    </tr>
    <xsl:apply-templates select="$source/page/content/data-dict/section" mode="row"/>
  </xsl:template>

</xsl:stylesheet>
