<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="fres dc rdf">

  <!--
File:  newGuest.xslt

Description:

    This file creates an XML representation of the submitted form data
    for a new guest, stores this new document in the repository, and
    uses a docdef to map the document's data into statements in the RDF
    model. The user is then redirected back to front.xslt.

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:output method='xml'/>

  <xsl:param name='name'/>
  <xsl:param name='email'/>
  <xsl:param name='description'/>
  <xsl:param name='fres:uri-path'/>

  <xsl:template match="/">
    <fhttp:response-uri uri='{fres:uri-path}?xslt=front.xslt'/>
    <fcore:create-document docdef='../GuestBook.docdef' base-path='data'>
      <guest>
        <name><xsl:value-of select='$name'/></name>
        <email><xsl:value-of select='$email'/></email>
        <description><xsl:value-of select='$description'/></description>
      </guest>
    </fcore:create-document>
  </xsl:template>

</xsl:stylesheet>
