from xml.dom import Node
from Ft.Xml import XML_NAMESPACE, XMLNS_NAMESPACE, EMPTY_PREFIX, EMPTY_NAMESPACE

def GetAllNs(node):
    #The xml namespace is implicit
    nss = {'xml': XML_NAMESPACE}
    if node.nodeType == Node.ATTRIBUTE_NODE and node.ownerElement:
        return GetAllNs(node.ownerElement)
    if node.nodeType == Node.ELEMENT_NODE:
        # There are some edge cases here to worry about.
        #1. The element's prefix/ns could be different then a ns decl, the element should win
        #2  An Attributes preifx/ns could be different then a ns decl or the elements.  The element should win
        #   over all and the attributes should win over ns decls

        for attr in node.attributes.values():
            # xmlns="uri" or xmlns:foo="uri"
            if attr.namespaceURI == XMLNS_NAMESPACE:
                if attr.localName == 'xmlns':
                    #Not swapped around
                    if not nss.has_key(attr.prefix):
                        nss[attr.prefix] = attr.value
                # xmlns:foo="uri"
                elif attr.prefix:
                    # "foo" prefix -> uri
                    if not nss.has_key(attr.localName):
                        nss[attr.localName] = attr.value
                # xmlns="uri"
                else:
                    # default ns -> uri
                    if not nss.has_key(EMPTY_PREFIX):
                        nss[EMPTY_PREFIX] = attr.value
            # A prefixed attribute name may have had its namespace URI set
            # by the DOM without there having been an xmlns:prefix="uri"
            # that would have been detected by the code above
            elif attr.namespaceURI:
                nss[attr.prefix] = attr.namespaceURI
        if node.namespaceURI:
            nss[node.prefix] = node.namespaceURI

    if node.parentNode:
        #Inner NS/Prefix mappings take precedence over outer ones
        parent_nss = GetAllNs(node.parentNode)
        parent_nss.update(nss)
        nss = parent_nss
    return nss


def _seek_nss(node, nss):
    if node.nodeType == Node.ELEMENT_NODE:
        # Don't overwrite previously declared declarations
        if not nss.has_key(node.prefix):
            nss[node.prefix] = node.namespaceURI

        prefix = None
        namespaceURI = EMPTY_NAMESPACE
        for attr in node.attributes.values():
            if attr.namespaceURI == XMLNS_NAMESPACE:
                # xmlns="uri" or xmlns:foo="uri"
                namespaceURI = attr.value
                prefix = attr.prefix
                if prefix is not None:
                    # xmlns:foo="uri"
                    prefix = attr.localName
            elif attr.namespaceURI:
                # A prefixed attribute name may have had its namespace URI
                # set by the DOM without there having been an
                # xmlns:prefix="uri" that would have been detected by the
                # code above
                namespaceURI = attr.namespaceURI
                prefix = attr.prefix

            # Don't overwrite previously declared declarations
            if not nss.has_key(prefix):
                nss[prefix] = namespaceURI

    for child in node.childNodes:
        if child.nodeType == Node.ELEMENT_NODE:
            _seek_nss(child, nss)
    return nss


def SeekNss(node):
    '''traverses the tree to seek an approximate set of defined namespaces'''
    nss = _seek_nss(node, {})
    if nss.get(None, 0) == EMPTY_NAMESPACE:
        # Don't expose the implied default namespace
        del nss[None]
    return nss
