########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/XInclude.py,v 1.11 2003/05/01 05:48:18 uogbuji Exp $
"""
Handles XInclude: http://www.w3.org/TR/xinclude

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""


XINCLUDE_NAMESPACE = u'http://www.w3.org/2001/XInclude'

NONNORMATIVE_SCHEMA_FOR_XINCLUDE_ELEMENT = """
<xs:schema
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:xi="http://www.w3.org/2001/XInclude"
  targetNamespace="http://www.w3.org/2001/XInclude">

  <xs:element name="include">
    <xs:complexType mixed="true">
      <xs:attribute name="href" type="xs:anyURI" use="required"/>
      <xs:attribute name="parse">
        <xs:simpleType>
          <xs:restriction base="xs:string">
            <xs:enumeration value="xml"/>
            <xs:enumeration value="text"/>
          </xs:restriction>
        </xs:simpleType>
      </xs:attribute>
      <xs:attribute name="encoding" type="xs:string"/>
      <xs:anyAttribute />
    </xs:complexType>
  </xs:element>

</xs:schema>
"""

class XIncludeException(Exception):

    CIRCULAR_INCLUDE_ERROR = 1
    RESOURCE_ERROR = 2
    MISSING_HREF = 3
    INVALID_PARSE_ATTR = 4

    def __init__(self, code, extra=None):
        # args ::= (code, object?)?
        msg = g_errorMessages[code]
        if extra:
            msg = msg + '\n' + str(extra)
        Exception.__init__(self, msg)
        self.code = code
        self.msg = msg

g_errorMessages = {
    XIncludeException.CIRCULAR_INCLUDE_ERROR: "Circular Inclusion",
    XIncludeException.RESOURCE_ERROR: "Invalid resource, or not well-formed XML",
    XIncludeException.MISSING_HREF : 'Missing or empty href attribute',
    XIncludeException.INVALID_PARSE_ATTR : "Invalid value '%s' for parse attribute",
    }

# We really dont need to do anything special due to the fact that
# the default readers, by default, expand XIncludes.

def ProcessIncludesFromUri(uri, validate=0):
    if validate:
        from Ft.Xml.Domlette import ValidatingReader as reader
    else:
        from Ft.Xml.Domlette import NonvalidatingReader as reader
    return reader.parseUri(uri)
        
def ProcessIncludesFromString(string, uri='', validate=0):
    if validate:
        from Ft.Xml.Domlette import ValidatingReader as reader
    else:
        from Ft.Xml.Domlette import NonvalidatingReader as reader
    return reader.parseString(string, uri)

def ProcessIncludesFromSource(inputSource, validate=0):
    if validate:
        from Ft.Xml.Domlette import ValidatingReader as reader
    else:
        from Ft.Xml.Domlette import NonvalidatingReader as reader
    return reader.parse(inputSource)
