########################################################################
#
# File Name:            NullWriter.py
#
# Documentation:        http://docs.4suite.org/4XSLT/NullWriter.py.html
#
"""
Implements an empty writer for XSLT processor output
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from OutputParameters import OutputParameters
from Ft.Xml import EMPTY_NAMESPACE, XMLNS_NAMESPACE
from Ft.Xml.XPath import Conversions, NAMESPACE_NODE
from xml.dom import Node
from Ft.Xml.Domlette import GetAllNs


class NullWriter:
    '''
    All writers should subclass from NullWriter
    '''
    def __init__(self, outputParams=None):
        self._outputParams = outputParams or OutputParameters()
        return

    def getMediaType(self):
        return self._outputParams.mediaType

    def getStream(self):
        return None

    def getResult(self):
        return ''

    def startDocument(self):
        return

    def endDocument(self):
        return
    
    def text(self, text, escapeOutput=1, asis=0):
        return
    
    def attribute(self, name, value, namespace=None):
        return

    def processingInstruction(self, target, data):
        return

    def comment(self, body):
        return

    def startElement(self, name, namespace=None, extraNss=None):
        return

    def endElement(self, name, namespace=None):
        return

    def namespace(self, prefix, namespace):
        return

    def copyNodes(self, nodeOrNodelist):
        if isinstance(nodeOrNodelist, list):  #Python 2.2 only
            for node in nodeOrNodelist:
                self.copyNodes(node)
            return
        node = nodeOrNodelist
        if node.nodeType in [Node.DOCUMENT_NODE, Node.DOCUMENT_FRAGMENT_NODE]:
            for child in node.childNodes:
                self.copyNodes(child)
        if node.nodeType == Node.TEXT_NODE:
            self.text(node.data)
        elif node.nodeType == Node.ELEMENT_NODE:
            #The GetAllNs is needed to copy the namespace nodes
            self.startElement(node.nodeName, node.namespaceURI,
                                               extraNss=GetAllNs(node))
            for attr in node.attributes.values():
                if attr.namespaceURI != XMLNS_NAMESPACE:
                    self.attribute(attr.name, attr.value,
                                                    attr.namespaceURI)
            for child in node.childNodes:
                self.copyNodes(child)
            self.endElement(node.nodeName, node.namespaceURI)
        elif node.nodeType == Node.ATTRIBUTE_NODE:
            if node.namespaceURI != XMLNS_NAMESPACE:
                self.attribute(node.name, node.value,
                                                node.namespaceURI)
        elif node.nodeType == Node.COMMENT_NODE:
            self.comment(node.data)
        elif node.nodeType == Node.PROCESSING_INSTRUCTION_NODE:
            self.processingInstruction(node.target, node.data)
        elif node.nodeType == NAMESPACE_NODE:
            self.namespace(node.nodeName, node.value)
        else:
            pass
        return

