########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/Xslt/StringWriter.py,v 1.3 2003/07/24 23:11:25 jkloth Exp $
"""
A specialized writer that only captures text output events.

Copyright 2002 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import NullWriter

class StringWriter(NullWriter.NullWriter):
    def __init__(self, outputParams):
        NullWriter.NullWriter.__init__(self, outputParams)
        self._result = []
        self._ignore_events = 0
        self.had_nontext = 0

    def getResult(self):
        return u"".join(self._result)

    def text(self, text, escapeOutput=1, asis=0):
        if not self._ignore_events:
            self._result.append(text)
        return

    def startElement(self, name, namespace=None, extraNss=None):
        # Ignore non-text creation as per XSLT 1.0 spec
        self._ignore_events += 1
        self.had_nontext = 1
        return

    def endElement(self, name, namespace=None):
        # Ignore non-text creation as per XSLT 1.0 spec
        self._ignore_events -= 1
        return

    def comment(self, body):
        self.had_nontext = 1
        return

    def processingInstruction(self, target, data):
        self.had_nontext = 1
        return

    def attribute(self, name, value, namespace=None):
        self.had_nontext = 1
        return
