#ifndef __DOM__ATTR__
#define __DOM__ATTR__

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "node.h"

  typedef struct {
    PyNode_HEAD
    PyObject *namespaceURI;
    PyObject *prefix;
    PyObject *localName;
    PyObject *nodeName;
    PyObject *nodeValue;
  } PyAttrObject;

#define PyAttr_NAMESPACE_URI(op) (((PyAttrObject *)(op))->namespaceURI)
#define PyAttr_PREFIX(op) (((PyAttrObject *)(op))->prefix)
#define PyAttr_LOCAL_NAME(op) (((PyAttrObject *)(op))->localName)
#define PyAttr_NODE_VALUE(op) (((PyAttrObject *)(op))->nodeValue)

  extern PyTypeObject PyDomletteAttr_Type;

#define PyAttr_Check(op) ((op)->ob_type == &PyDomletteAttr_Type)

  int DomletteAttr_Init(void);
  void DomletteAttr_Fini(void);

  PyAttrObject *Attr_CloneNode(PyObject *node, int deep,
                               PyNodeObject *newOwnerDocument);

  int attr_test_ref_counts(PyObject *tester,PyAttrObject *node,long *childCtr,PyObject *internDict,int base);

  /*Attr Methods */



#ifdef __cplusplus
}
#endif

#endif /* __DOM__ATTR__ */
