#include "ds_tools.h"
#include "expat_module.h"
#include <stdlib.h>
#include <stdio.h>
#include "debug.h"

/* NsMapping */

void free_nsmapping(void *ptr)
{
  NsMapping *nsm = (NsMapping *)ptr;
  Py_DECREF(nsm->uri);
  Py_DECREF(nsm->prefix);
#ifdef DEBUG_PARSER
  fprintf(stderr, "Free nsmapping");
  _PyObject_Dump(nsm->uri);
  _PyObject_Dump(nsm->prefix);
#endif
  free(nsm);
}


int matchUri(const void *t, const void *c){
  PyObject *target_uri = (PyObject *)t;
  NsMapping *candidate = (NsMapping *)c;
  return (PyObject_Compare(target_uri, candidate->uri) == 0);
}


int matchPrefix(const void *t, const void *c){
  PyObject *target_prefix = (PyObject *)t;
  NsMapping *candidate = (NsMapping *)c;
  return (PyObject_Compare(target_prefix, candidate->prefix) == 0);
}


int matchNsMapping(const void *a, const void *b){
  NsMapping *x = (NsMapping *)a;
  NsMapping *y = (NsMapping *)b;
  return (PyObject_Compare(x->uri, y->uri) == 0 && PyObject_Compare(x->prefix, y->prefix) == 0);
}


/* Debugging tools */


